/*


          ██████╗    ██╗    ██████╗    ██╗   ████████╗    █████╗    ██╗
          ██╔══██╗   ██║   ██╔════╝    ██║   ╚══██╔══╝   ██╔══██╗   ██║
          ██║  ██║   ██║   ██║  ███╗   ██║      ██║      ███████║   ██║
          ██║  ██║   ██║   ██║   ██║   ██║      ██║      ██╔══██║   ██║
          ██████╔╝   ██║   ╚██████╔╝   ██║      ██║      ██║  ██║   ███████╗
          ╚═════╝    ╚═╝    ╚═════╝    ╚═╝      ╚═╝      ╚═╝  ╚═╝   ╚══════╝

   ██████╗    ██████╗    ██████╗    ███████╗   ███████╗   ██╗    ██████╗    ███╗   ██╗
  ██╔════╝   ██╔═══██╗   ██╔══██╗   ██╔════╝   ██╔════╝   ██║   ██╔════╝    ████╗  ██║
  ██║        ██║   ██║   ██║  ██║   █████╗     ███████╗   ██║   ██║  ███╗   ██╔██╗ ██║
  ██║        ██║   ██║   ██║  ██║   ██╔══╝     ╚════██║   ██║   ██║   ██║   ██║╚██╗██║
  ╚██████╗   ╚██████╔╝   ██████╔╝   ███████╗   ███████║   ██║   ╚██████╔╝   ██║ ╚████║
   ╚═════╝    ╚═════╝    ╚═════╝    ╚══════╝   ╚══════╝   ╚═╝    ╚═════╝    ╚═╝  ╚═══╝


  Autor: Digital Codesign
  Version: 1.0.0
  Fecha de creación: Septiembre de 2024
  Fecha de version: Septiembre de 2024
  Repositorio: https://github.com/DigitalCodesign/MentorBit-LDR
  Descripcion:
    Esta libreria esta especificamente diseñada para ser utilizada junto con
    el modulo MentorBit LDR
  Metodos principales:
    MentorBitLDR -> constructor de la clase
    lecturaDigital -> Devuelve el valor de la lectura digital de la LDR.
    lecturaAnalogica -> Devuelve el valor de la lectura analogica de la LDR.

*/

#ifndef MentorBitLDR_h
#define MentorBitLDR_h

#include <arduino.h>
#include <MentorPort.h>

class MentorBitLDR : public MentorPort
{

    public: 

        MentorBitLDR(uint8_t analog_pin_ldr = 0, uint8_t digital_pin_ldr = 0);
        bool lecturaDigital();
        uint16_t lecturaAnalogica();
        void configPort(const Port& port) override;

    private:

        Port _port;
};



#endif