/*


            ██████╗    ██╗    ██████╗    ██╗   ████████╗    █████╗    ██╗               
            ██╔══██╗   ██║   ██╔════╝    ██║   ╚══██╔══╝   ██╔══██╗   ██║               
            ██║  ██║   ██║   ██║  ███╗   ██║      ██║      ███████║   ██║               
            ██║  ██║   ██║   ██║   ██║   ██║      ██║      ██╔══██║   ██║               
            ██████╔╝   ██║   ╚██████╔╝   ██║      ██║      ██║  ██║   ███████╗          
            ╚═════╝    ╚═╝    ╚═════╝    ╚═╝      ╚═╝      ╚═╝  ╚═╝   ╚══════╝          
                                                                                        
     ██████╗    ██████╗    ██████╗    ███████╗   ███████╗   ██╗    ██████╗    ███╗   ██╗
    ██╔════╝   ██╔═══██╗   ██╔══██╗   ██╔════╝   ██╔════╝   ██║   ██╔════╝    ████╗  ██║
    ██║        ██║   ██║   ██║  ██║   █████╗     ███████╗   ██║   ██║  ███╗   ██╔██╗ ██║
    ██║        ██║   ██║   ██║  ██║   ██╔══╝     ╚════██║   ██║   ██║   ██║   ██║╚██╗██║
    ╚██████╗   ╚██████╔╝   ██████╔╝   ███████╗   ███████║   ██║   ╚██████╔╝   ██║ ╚████║
     ╚═════╝    ╚═════╝    ╚═════╝    ╚══════╝   ╚══════╝   ╚═╝    ╚═════╝    ╚═╝  ╚═══╝ 
        

    Autor: Digital Codesign
    Version: 1.0.0
    Fecha de creación: Septiembre de 2024
    Fecha de version: Septiembre de 2024
    Repositorio: https://github.com/DigitalCodesign/MentorBit-DetectorLluvia
    Descripcion: 
        Este sketch es un ejemplo básico de como obtener la lectura digital y en 
        caso de tener un valor de "true" mostrar un mensaje por el monitor serial

*/

// Incluimos la libreria MentorBitDetectorLluvia
#include <MentorBitDetectorLluvia.h>

// Definimos los pines a los que se va a conectar el modulo
#define PIN_ANALOGICO A4
#define PIN_DIGITAL 24

// Se crea el objeto Detector_lluvia indicandole los pines a los que se conecta
MentorBitDetectorLluvia Detector_lluvia(PIN_DIGITAL, PIN_ANALOGICO);

void setup(){
    // Se inicializa el bus serial para mostrar el valor analogico;
    Serial.begin(9600);
}

void loop(){
    // Evaluar el estado de la salida digital del modulo
    if(!Detector_lluvia.obtenerLecturaDigital()){
        Serial.println("La salida digital se ha activado");
        // Colocamos un pequeño delay para evitar llenar el monitor serial
        delay(1000);
    }
    

}