/*


            ██████╗    ██╗    ██████╗    ██╗   ████████╗    █████╗    ██╗               
            ██╔══██╗   ██║   ██╔════╝    ██║   ╚══██╔══╝   ██╔══██╗   ██║               
            ██║  ██║   ██║   ██║  ███╗   ██║      ██║      ███████║   ██║               
            ██║  ██║   ██║   ██║   ██║   ██║      ██║      ██╔══██║   ██║               
            ██████╔╝   ██║   ╚██████╔╝   ██║      ██║      ██║  ██║   ███████╗          
            ╚═════╝    ╚═╝    ╚═════╝    ╚═╝      ╚═╝      ╚═╝  ╚═╝   ╚══════╝          
                                                                                        
     ██████╗    ██████╗    ██████╗    ███████╗   ███████╗   ██╗    ██████╗    ███╗   ██╗
    ██╔════╝   ██╔═══██╗   ██╔══██╗   ██╔════╝   ██╔════╝   ██║   ██╔════╝    ████╗  ██║
    ██║        ██║   ██║   ██║  ██║   █████╗     ███████╗   ██║   ██║  ███╗   ██╔██╗ ██║
    ██║        ██║   ██║   ██║  ██║   ██╔══╝     ╚════██║   ██║   ██║   ██║   ██║╚██╗██║
    ╚██████╗   ╚██████╔╝   ██████╔╝   ███████╗   ███████║   ██║   ╚██████╔╝   ██║ ╚████║
     ╚═════╝    ╚═════╝    ╚═════╝    ╚══════╝   ╚══════╝   ╚═╝    ╚═════╝    ╚═╝  ╚═══╝ 
        

    Autor: Digital Codesign
    Version: 1.0.0
    Fecha de creación: Septiembre de 2024
    Fecha de version: Septiembre de 2024
    Repositorio: https://github.com/DigitalCodesign/MentorBit-DetectorLluvia
    Descripcion: 
        Esta libreria esta especificamente diseñada para ser utilizada junto con 
        el modulo MentorBit detector de lluvia
    Metodos principales:
        MentorBitDetectorLluvia -> constructor de la clase
        obtenerLecturaDigital -> obtiene un valor de true o false (umbral ajustable con el potenciometro)
        obtenerLecturaAnalogica -> da un valor analogico de 2 bytes 

*/

#include <MentorBitDetectorLluvia.h>

MentorBitDetectorLluvia::MentorBitDetectorLluvia(uint8_t detector_pin = 0, uint8_t analog_detector_pin = 0) {
    _port.gpios[0] = detector_pin;
    _port.gpios[1] = analog_detector_pin;
}

bool MentorBitDetectorLluvia::obtenerLecturaDigital(){
    bool value;
    value = digitalRead(_port.gpios[1]);
    return value;
}

uint16_t MentorBitDetectorLluvia::obtenerLecturaAnalogica(){
    uint16_t value;
    value = analogRead(_port.gpios[0]);
    return value;
}

void MentorBitDetectorLluvia::configPort(const Port& port) {

    _port.type = port.type;
    _port.location = port.location;
    _port.gpios[0] = port.gpios[0];
    _port.gpios[1] = port.gpios[1];

}
