#ifndef ESP32_WEBSOCKET_SERVER_H
#define ESP32_WEBSOCKET_SERVER_H

#include <DIYablesWebApps.h>
#include <DIYables_ESP32_WebSocket.h>
#include "ESP32WebSocket.h"

/**
 * ESP32 implementation of IWebSocketServer.
 * Minimal platform-specific wrapper - delegates client management to core.
 */
class ESP32WebSocketServer : public IWebSocketServer {
private:
    DIYables_ESP32_WebSocket server;
    uint16_t port;
    
    // Store callbacks
    ConnectionCallback connectionCallback;
    MessageCallback messageCallback;
    CloseCallback closeCallback;
    
    // Use core client manager instead of platform-specific logic
    WebSocketClientManager clientManager;
    
    // Static wrapper functions to bridge between ESP32 callbacks and our interface
    static void onConnectionWrapper(net::WebSocket& ws);
    static void onMessageWrapper(net::WebSocket& ws, const net::WebSocket::DataType dataType, const char* message, uint16_t length);
    static void onCloseWrapper(net::WebSocket& ws, const net::WebSocket::CloseCode code, const char* reason, uint16_t length);
    
    // Static instance for callback bridging
    static ESP32WebSocketServer* instance;
    
public:
    ESP32WebSocketServer(uint16_t serverPort);
    virtual ~ESP32WebSocketServer();
    
    // Server lifecycle
    bool begin() override;
    void end() override;
    void listen() override;
    
    // Event callbacks
    void onConnection(ConnectionCallback callback) override;
    void onMessage(MessageCallback callback) override;
    void onClose(CloseCallback callback) override;
    
    // Configuration
    uint16_t getPort() const override;
    
    // Broadcasting methods
    void broadcastText(const char* message) override;
    void broadcastBinary(const uint8_t* data, uint16_t length) override;
};


#endif
