#ifndef ESP32_WEBSOCKET_H
#define ESP32_WEBSOCKET_H

#include <DIYablesWebApps.h>
#include <DIYables_ESP32_WebServer.h>

/**
 * ESP32 implementation of IWebSocket.
 * Minimal platform wrapper - no static instance management.
 */
class ESP32WebSocket : public IWebSocket {
private:
    WebSocket* webSocket;
    bool ownsWebSocket;
    
    // Callback storage
    void (*messageCallback)(IWebSocket* ws, const DataType dataType, const char* message, uint16_t length);
    void (*closeCallback)(IWebSocket* ws, const CloseCode code, const char* reason, uint16_t length);
    
public:
    ESP32WebSocket(WebSocket* ws, bool takeOwnership = false);
    ESP32WebSocket(WebSocket& ws);
    virtual ~ESP32WebSocket();
    
    // Connection management
    bool isConnected() override;
    void close(CloseCode code = NORMAL_CLOSURE, const char* reason = nullptr) override;
    
    // Message handling
    bool send(DataType dataType, const char* message, uint16_t length) override;
    
    // Callback management (per-connection event handling)
    void onMessage(void (*callback)(IWebSocket* ws, const DataType dataType, const char* message, uint16_t length)) override;
    void onClose(void (*callback)(IWebSocket* ws, const CloseCode code, const char* reason, uint16_t length)) override;
    
    // Client information
    String getRemoteIP() override;
    uint16_t getRemotePort() override;
    
    // Internal method to get the underlying WebSocket for platform-specific operations
    WebSocket* getUnderlyingWebSocket();
};


#endif
