#include "ESP32WebClient.h"

// Constructor
ESP32WebClient::ESP32WebClient(WiFiClient wifiClient) 
    : client(wifiClient) {}

// Destructor
ESP32WebClient::~ESP32WebClient() {
    // No need to delete anything - client is stored by value
}

// Connection management
bool ESP32WebClient::connected() {
    return client.connected();
}

void ESP32WebClient::stop() {
    client.stop();
}

// Stream interface implementation
int ESP32WebClient::available() {
    return client.available();
}

int ESP32WebClient::read() {
    return client.read();
}

int ESP32WebClient::peek() {
    return client.peek();
}

size_t ESP32WebClient::write(uint8_t data) {
    return client.write(data);
}

size_t ESP32WebClient::write(const uint8_t* buffer, size_t size) {
    return client.write(buffer, size);
}

void ESP32WebClient::flush() {
    client.flush();
}

// Additional convenience methods
String ESP32WebClient::readStringUntil(char terminator) {
    return client.readStringUntil(terminator);
}

size_t ESP32WebClient::println(const String& str) {
    return client.println(str);
}

size_t ESP32WebClient::println() {
    return client.println();
}

size_t ESP32WebClient::print(const String& str) {
    return client.print(str);
}

