#include "ESP32ServerFactory.h"

// Factory methods
INetworkProvider* ESP32ServerFactory::createNetworkProvider() {
    return new ESP32NetworkProvider();
}

IWebServer* ESP32ServerFactory::createWebServer(uint16_t port) {
    return new ESP32WebServer(port);
}

IWebSocketServer* ESP32ServerFactory::createWebSocketServer(uint16_t port) {
    return new ESP32WebSocketServer(port);
}

// Platform information
String ESP32ServerFactory::getPlatformName() const {
    return "ESP32";
}

