#ifndef ESP32_NETWORK_PROVIDER_H
#define ESP32_NETWORK_PROVIDER_H

#include <DIYablesWebApps.h>
#include <DIYables_ESP32_WebServer.h>

/**
 * ESP32 implementation of INetworkProvider.
 * Wraps the ESP32 WiFi class.
 */
class ESP32NetworkProvider : public INetworkProvider {
private:
    String lastSSID;
    String lastPassword;
    
public:
    ESP32NetworkProvider() = default;
    virtual ~ESP32NetworkProvider() = default;
    
    // Connection management
    bool begin(const char* ssid, const char* password) override;
    void end() override;
    bool reconnect() override;
    
    // Status and information
    Status getStatus() override;
    bool isConnected() override;
    String getLocalIP() override;
    String getSSID() override;
    int32_t getRSSI() override;

private:
    bool waitForConnection();
};


#endif
