#ifndef ESP32_WEB_SERVER_H
#define ESP32_WEB_SERVER_H

#include <DIYablesWebApps.h>
#include <DIYables_ESP32_WebServer.h>
#include "ESP32WebClient.h"

/**
 * ESP32 implementation of IWebServer.
 * Wraps the ESP32 WiFiServer class.
 */
class ESP32WebServer : public IWebServer {
private:
    WiFiServer server;
    uint16_t port;
    
public:
    ESP32WebServer(uint16_t serverPort);
    virtual ~ESP32WebServer() = default;
    
    // Server lifecycle
    bool begin() override;
    void end() override;
    
    // Client management
    IWebClient* available() override;
    
    // Configuration
    uint16_t getPort() const override;
};


#endif
