#include "ESP32WebServer.h"

// Constructor
ESP32WebServer::ESP32WebServer(uint16_t serverPort) : server(serverPort), port(serverPort) {}

// Server lifecycle
bool ESP32WebServer::begin() {
    server.begin();
    return true; // WiFiServer.begin() doesn't return a status
}

void ESP32WebServer::end() {
    server.end();
}

// Client management
IWebClient* ESP32WebServer::available() {
    WiFiClient client = server.available();
    if (client) {
        return new ESP32WebClient(client);
    }
    return nullptr;
}

// Configuration
uint16_t ESP32WebServer::getPort() const {
    return port;
}

