#ifndef ESP32_WEB_CLIENT_H
#define ESP32_WEB_CLIENT_H


#include <DIYablesWebApps.h>
#include <DIYables_ESP32_WebServer.h>

/**
 * ESP32 implementation of IWebClient.
 * Wraps the ESP32 WiFiClient class.
 */
class ESP32WebClient : public IWebClient {
private:
    WiFiClient client;
    
public:
    ESP32WebClient(WiFiClient wifiClient);
    virtual ~ESP32WebClient();
    
    // Connection management
    bool connected() override;
    void stop() override;
    
    // Stream interface implementation
    int available() override;
    int read() override;
    int peek() override;
    size_t write(uint8_t data) override;
    size_t write(const uint8_t* buffer, size_t size) override;
    void flush() override;
    
    // Additional convenience methods (use default implementations from IWebClient)
    String readStringUntil(char terminator) override;
    size_t println(const String& str) override;
    size_t println() override;
    size_t print(const String& str) override;
};


#endif
