#ifndef ESP32_SERVER_FACTORY_H
#define ESP32_SERVER_FACTORY_H

#include <DIYablesWebApps.h>

#include "ESP32NetworkProvider.h"
#include "ESP32WebServer.h"
#include "ESP32WebSocketServer.h"

/**
 * Server factory for ESP32.
 * Creates ESP32-specific implementations of network interfaces.
 */
class ESP32ServerFactory : public IServerFactory {
public:
    ESP32ServerFactory() = default;
    virtual ~ESP32ServerFactory() = default;
    
    // Factory methods
    INetworkProvider* createNetworkProvider() override;
    IWebServer* createWebServer(uint16_t port) override;
    IWebSocketServer* createWebSocketServer(uint16_t port) override;
    
    // Platform information
    String getPlatformName() const override;
};


#endif
