/*!
 * \file      soft-se-hal.h
 *
 * \brief     Secure Element hardware abstraction layer implementation
 *
 * \copyright Revised BSD License, see section \ref LICENSE.
 *
 * \code
 *                ______                              _
 *               / _____)             _              | |
 *              ( (____  _____ ____ _| |_ _____  ____| |__
 *               \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 *               _____) ) ____| | | || |_| ____( (___| | | |
 *              (______/|_____)_|_|_| \__)_____)\____)_| |_|
 *              (C)2020 Semtech
 *
 *               ___ _____ _   ___ _  _____ ___  ___  ___ ___
 *              / __|_   _/_\ / __| |/ / __/ _ \| _ \/ __| __|
 *              \__ \ | |/ _ \ (__| ' <| _| (_) |   / (__| _|
 *              |___/ |_/_/ \_\___|_|\_\_| \___/|_|_\\___|___|
 *              embedded.connectivity.solutions===============
 *
 * \endcode
 *
 */
#include "boards/mcu/board.h"
#include "radio/radio.h"

#include "soft-se-hal.h"

void SoftSeHalGetUniqueId( uint8_t *id )
{
    BoardGetUniqueId( id );
}

uint32_t SoftSeHalGetRandomNumber( void )
{
    return Radio.Random( );
}
