# Generate Custom Font 
## Table of Contents
* [Environment Building](#环境搭建)
* [Generate Custom Font](#生成自定义字体)
## Environment Building
Before we use setup.py script to create custom font, the preparation below needs to be completed first:
- **Log in the website https://www.python.org/downloads/ to download python3.6 and above.**<br>
- **When the installation done, use the following commands to install a Python third-party dependency package:** <br>
    - pip3 install numpy
    - pip install freetype-py 
    - pip install chardet

## Generate Custom Font
- **Store the TTF font file into ttf folder, for example, SIMKAI.TTF(Simplified Regular script)**
- **Input any character you want into text.txt file, such as: Hello, world!**
- **Open config.txt file, configure the name prefix and font size of the created font file:**
    - **FontFileNamePre: name prefix of the created font file**
    - **FontSizeList: List of the created font size. If it is empty[], a file of 12,18,24,36,48,72 size will be generated by default. If it is a Chinese character, it should not be less than 12.**<br>
  **FontFileNamePre** Represent the prefix of the file name, and default means there is no prefix.<br>
        - Example 1：If **FontFileNamePre = default**<br>
             **FontSizeList = [12]**<br>
    Generate a file named **SIMKAIFont12pt.h**<br>
        - Example 2：If **FontFileNamePre = English**<br>
             **FontSizeList = [12]**<br>
   Generate a file named **EnglishSIMKAIFont12pt.h**<br>
        - Example 3：If FontFileNamePre = English<br>
             **FontSizeList = [12,24]**<br>
    Generate files named **EnglishSIMKAIFont12pt.h**and **EnglishSIMKAIFont24pt.h**<br>
**Name and prefix of the generated font file = FontFileNamePre + TTF file name + Font + size + pt + .h**<br>
Among them, FontFileNamePre should only be **English characters**, size refers to the generated font size.<br>
- **Run setup.py script, font files with suffix .h, and pop out a font.txt text. Now complete the following steps, then you can display "Hello, world!" on the screen. <br>**
    - Copy the files in font folder to the directory DFRobot_GDL\src\Fonts\Fonts;
    - Copy the content in the font.txt into the file DFRobot_GDL\src\Fonts\DFRobot_Font.h;
    - Open Arduino IDE, construct object, such as tft, call tft.setFont(&SIMKAIFont48pt);
    - call tft.println("Hello, wrold!"), then the text "Hello, world!" will be displayed on the screen.
- **Note: mainboards like UNO don't have too much ROM and RAM. If you generate too many fonts at a time, errors caused by insufficient memory will be reported.**
