
# DCCEXProtocol

For the full documentation, please refer to the [DCC-EX website](https://dcc-ex.com/DCCEXProtocol/index.html).

# Credits

The delegate and connection code in this library is taken directly from the WiThrottle library by **Copyright © 2018-2019 Blue Knobby Systems Inc.**
The rest of the code has been developed by Peter Akers (Flash62au), Peter Cole (peteGSX), and Chris Harlow (UKBloke).

----

# DCC-EX Native command protocol library

This library implements the DCC-EX Native command protocol (as used in EX-CommandStation ONLY), allowing a device to connect to the server and act as a client (such as a hardware based throttle).

The implementation of this library is tested on ESP32 based devices running the Arduino framework. There's nothing in here that's specific to the ESP32, and little of Arduino that couldn't be replaced as needed.

There has also been limited testing on STM32F103C8 Bluepill.

## Basic Design Principles

First of all, this library implements the DCC-EX Native protocol in a non-blocking fashion. After creating a DCCEXProtocol object, you set up various necessities such as the network connection and a debug console (see [Dependency Injection][depinj]).

Then, you call the ```check()``` method as often as you can (ideally, once per invocation of the ```loop()``` method) and the library will manage the I/O stream, reading in/parsing commands and calling methods on the [delegate] as information is available.

These patterns (Dependency Injection and Delegation) allow you to keep the different parts of your sketch from becoming too intertwined with each other. Nothing in the code that manages the pushbuttons or speed knobs needs to have any detailed knowledge of the DCC-EX native protocol.

### DCCEXProtocol Class

Full documentation of the classes is available via the [DCC-EX website](https://dcc-ex.com/DCCEXProtocol/index.html).

The DCCEXProtocol class manages all relevant objects advertised by a DCC-EX EX-CommandStation and exposes simple methods to control these objects from the client software.

These objects include:

- Roster entries
- Route entries
- Turnouts/Points
- Turntables (noting that these objects are only available in development versions)

This means the client software does not need to explicitly manage the state of these objects whilever the ```check()``` method mentioned above is called appropriately.

### DCCEXProtocolDelegate Class

The DCCEXProtocolDelegate class enables the client software to respond to various events generated by a DCC-EX EX-CommandStation as either broadcasts or responses to commands.

The events able to be managed via this class are over and above those managed by the DCCEXProtocol class and are entirely customisable by the client software to provide dynamic user experience updates such as displaying status changes to objects as they are broadcast from the DCC-EX EX-CommandStation.

# Documentation

Documentation of the DCCEXProtocol library is available via the [DCC-EX website](file:///C:/Code/DCCEXProtocol/docs/_build/html/index.html).

For contributors wishing to build local copies of the documentation while updating the library, here is the very high level process of the requirements to make this work on Windows:

- Install [MSYS2 C++](https://code.visualstudio.com/docs/cpp/config-mingw#_prerequisites) compilers
- Install [CMake](https://cmake.org/download/) and ensure you select the option to add to your user path
- Install [Doxygen](https://www.doxygen.nl/download.html) and once complete, add to your user path
- Install the CMake Tools extension in VSCode
- Setup a Python virtual environment with "virtualenv venv" and activate with "venv\scripts\activate"
- Install required Python modules with "pip3 install -r requirements.txt"
- Change to the docs directory and run "make html"

----

# License

Creative Commons [CC-BY-SA 4.0][CCBYSA]   ![CCBYSA](https://i.creativecommons.org/l/by-sa/4.0/88x31.png)

**Free Software, Oh Yeah!**

[//]: # (These are reference links used in the body of this note and get stripped out when the markdown processor does its job. There is no need to format nicely because it shouldn't be seen. Thanks SO - http://stackoverflow.com/questions/4823468/store-comments-in-markdown-syntax)

   [depinj]: <https://en.wikipedia.org/wiki/Dependency_injection>
   [delegate]: <https://en.wikipedia.org/wiki/Delegation_(object-oriented_programming)>
   [CCBYSA]: <http://creativecommons.org/licenses/by-sa/4.0/>
