# Contributing

When contributing a major change to this repository, please first discuss the change you wish to make via an [issue](contributing/ISSUES.md) or via
[Slack](https://www.project-owl.com/slack). Minor issues can simply be addressed by sending a pull request.

> Join our [Discord Server](https://discord.gg/33gmAXJG) to learn about milestones, upcoming events, and to join our Townhall and Quack-Hour meetings every Monday at 2pm ET.

This project uses the [Developers Certificate of Origin (DCO)](#developer-certificate-of-origin) to validate that you own the rights to the code you want to contribute.

Please note we have a [Code of Conduct](#code-of-conduct), please follow it in all your interactions with the project and its community.

## Pull Request Process

1. Fork the repository (You will need to have [Git Large File Storage](https://help.github.com/en/github/managing-large-files/installing-git-large-file-storage) installed to clone it locally).
2. Commit your changes to your fork.
3. Submit a pull request.
4. Handle any feedback before the request is merged.
5. Accept our sincere **Thank you!**

## Developer Certificate of Origin

All [pull requests](contributing/PULL-REQUESTS.md) will require you to ensure the change is certified via the [Developer Certificate of Origin (DCO)](https://github.com/apps/dco/). The DCO is a lightweight way for contributors to certify that they wrote or otherwise have the right to submit the code they are contributing to the project.

See more details on how to [configure your `git` environment for the DCO](DEVELOPER_CERTIFICATE_OF_ORIGIN.md).

## Code of Conduct

We as members, contributors, and leaders pledge to make participation in our
community a harassment-free experience for everyone, regardless of age, body
size, visible or invisible disability, ethnicity, sex characteristics, gender
identity and expression, level of experience, education, socio-economic status,
nationality, personal appearance, race, religion, or sexual identity
and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming,
diverse, inclusive, and healthy community.

See the full [Code of Conduct](CODE_OF_CONDUCT.md).
