#include "ModbusTCPSlave.h"

bool ModbusTCPSlave::poll(Client& client) {
  if (!client) return false;
  if (!client.connected()) return false;
  if (!client.available()) return false;
  ModbusADU adu;
  uint8_t error = ModbusTCPComm.readAdu(client, adu);
  if (error) return false;
  processPdu(adu);
  ModbusTCPComm.writeAdu(client, adu);
  return true;
}
