#include "SerialWombat.h"
#include "SerialWombat18ABVGADriver.h"  // If this line throws an error, get SerialWombat18ABVGADriver library though the library manager
/*
This example shows how to configure pins 14-18 of the Serial Wombat 18AB chip to output VGA,
and display different colored text on different lines using text generated by the 
AdafruitGFX library, the SerialWombat18ABVGA pin mode, and the SerialWombat18ABVGADriver
wrapper to provide AdaFruitGFX compatible interfaces.

We will display the words Red, Blue, Green, Cyan, Magenta, Yellow and White in their colors.

Note that colors need to be set for an entire line of pixels, and that color handling is done
through the Serial Wombat 18AB Pin mode, not the color functions of the AdafruitGFX display.
You can almost think of it as putting a tinted color transparency over the screen at the 
driver layer.  Any of you kids ever play VecTrex?  

Serial Wombat 18AB Firmware 2.1 or later is needed to use this example.

This example assumes a Serial Wombat 18AB chip is attached to the Arduino board via I2C.
In this case we're assuming an ESP-01 module with I2C Data and Clock lines on ESP-02 pins 2 and 0.

Connections:
VGA VSYNC (VGA Pin 14) -> 100 ohm Resistor -> SW Pin 18
VGA HSYNC (VGA Pin 13) -> 100 ohm Resistor ->SW Pin 17
VGA Red   (VGA Pin 1) -> 280 ohm Resistor -> SW Pin 16
VGA Green (VGA Pin 2) -> 280 ohm Resistor -> SW Pin 15
VGA Blue (VGA Pin 3) -> 280 ohm Resistor -> SW Pin 14

A video demonstrating the use of the VGA pin mode on the Serial Wombat 18AB chip is available at:
TODO

Documentation for the VGA class is available at:
https://broadwellconsultinginc.github.io/SerialWombatArdLib/class_serial_wombat18_a_b_v_g_a.html

*/

SerialWombatChip sw;
SerialWombat18ABVGA vgaDriver(sw);
SerialWombat18ABVGADriver vgaDisplay(vgaDriver);


void setup() {
  // put your setup code here, to run once:
  Wire.begin(); 
  Serial.begin(115200);
  delay(500);

  uint8_t i2cAddress = sw.find();
  if (i2cAddress == 0) {
    showNotFoundError(); // see showErrorNotFound tab
  }
  sw.begin(Wire, i2cAddress);
  sw.queryVersion();
  Serial.print("Version "); Serial.println((char*)sw.fwVersion);
  versionCheck(); //see showErrorNotFound tab
  Serial.println("SW18AB Found.");


  vgaDriver.begin(18, 0x0000);

  showGraphicAndText();
}

void loop() {
  // put your main code here, to run repeatedly:
}



#define LINEHEIGHT 8  // Based on the size of the font
void showGraphicAndText()
{
  vgaDisplay.fillScreen(0);
  vgaDisplay.setCursor(0, 0);
  vgaDisplay.setTextSize(2);

  vgaDisplay.println("RED");
  vgaDisplay.println("GREEN");
  vgaDisplay.println("BLUE");
  vgaDisplay.println("CYAN");
  vgaDisplay.println("MAGENTA");
  vgaDisplay.println("YELLOW");
  vgaDisplay.println("WHITE");

  vgaDriver.setLineColor(4, 0, LINEHEIGHT * 2);  // 4 = Red
  vgaDriver.setLineColor(2, LINEHEIGHT * 2, LINEHEIGHT * 4);  // 2 = Green
  vgaDriver.setLineColor(1, LINEHEIGHT * 4, LINEHEIGHT * 6);  // 1 = Blue
  vgaDriver.setLineColor(3, LINEHEIGHT * 6, LINEHEIGHT * 8);  // 3 = Cyan
  vgaDriver.setLineColor(5, LINEHEIGHT * 8, LINEHEIGHT * 10);  // 5 = Magenta
  vgaDriver.setLineColor(6, LINEHEIGHT * 10, LINEHEIGHT * 12); // 6 = Yellow
  vgaDriver.setLineColor(7, LINEHEIGHT * 12, LINEHEIGHT * 14); // 7 = White
}
