/* Generated file by extensionutil.py */

#include "patch_base.h"
#include <EVE.h>
#include <HAL.h>


#if IS_EVE_API(5)

void EVE_CMD_REGION()
{
	HAL_Write32(0xffffff8f);
	HAL_IncCmdPointer(4);
}

void EVE_CMD_ENDREGION(int16_t p1, int16_t p2, int16_t p3, int16_t p4)
{
	HAL_Write32(0xffffff90);
	HAL_Write32((p1 & 0xffff) | ((uint32_t)p2<<16));
	HAL_Write32((p3 & 0xffff) | ((uint32_t)p4<<16));
	HAL_IncCmdPointer(12);
}

void EVE_CMD_TOUCHOFFSET(int16_t p1, int16_t p2)
{
	HAL_Write32(0xffffffae);
	HAL_Write32((p1 & 0xffff) | ((uint32_t)p2<<16));
	HAL_IncCmdPointer(8);
}

void EVE_CMD_ENDTOUCHOFFSET()
{
	HAL_Write32(0xffffffaf);
	HAL_IncCmdPointer(4);
}

int eve_loadpatch(void)
{
	// Extension code
	const uint8_t patchdata[] =
	{
		0x7c, 0xda, 0x00, 0x50, 0x00, 0x20, 0xd4, 0x07, 0x78, 0x9c, 0xed, 0x56, 0x7d, 0x70, 0x13, 0xc7,
		0x15, 0x5f, 0xdd, 0xca, 0xd8, 0x92, 0x6c, 0x59, 0x97, 0xa6, 0x21, 0x74, 0x90, 0x63, 0x32, 0x38,
		0x0a, 0x2d, 0x04, 0x67, 0x22, 0x60, 0x5a, 0x20, 0x59, 0xc9, 0x3a, 0xd9, 0x92, 0x6b, 0x12, 0x1a,
		0x9a, 0x76, 0x18, 0x8b, 0x5a, 0x41, 0x02, 0x7b, 0xc6, 0xd8, 0x8a, 0x7d, 0x27, 0x3e, 0xa6, 0xa5,
		0xeb, 0x92, 0x0f, 0x82, 0x35, 0x91, 0xf9, 0x30, 0x01, 0xa6, 0x64, 0x48, 0x86, 0x09, 0x6d, 0x02,
		0x2e, 0xd3, 0x96, 0x84, 0x26, 0x69, 0x7b, 0x27, 0xb0, 0x1d, 0x2a, 0x5b, 0x81, 0x80, 0xb1, 0x5b,
		0x02, 0xd5, 0x38, 0x69, 0x53, 0x77, 0xa6, 0x41, 0xd3, 0x3f, 0x92, 0x4c, 0x07, 0x66, 0xfb, 0xf6,
		0xee, 0x3c, 0xed, 0xa4, 0x9d, 0xfe, 0xd1, 0xbf, 0xef, 0x69, 0xde, 0xbd, 0xdf, 0xdb, 0xb7, 0xfb,
		0x76, 0xf5, 0x76, 0xdf, 0xdb, 0x45, 0x87, 0xd0, 0x35, 0x51, 0x5d, 0xb5, 0x1f, 0x5d, 0x6b, 0x50,
		0xb1, 0x86, 0xfa, 0xfa, 0x43, 0x73, 0xe4, 0x91, 0x90, 0xd3, 0x7f, 0x2a, 0xe4, 0x4a, 0xc5, 0xe5,
		0x8d, 0xed, 0xdf, 0x7b, 0x32, 0xde, 0x9b, 0x5c, 0x99, 0x51, 0x5f, 0x5c, 0xce, 0xd8, 0xa9, 0x90,
		0xfd, 0xc1, 0x07, 0xea, 0x57, 0xb2, 0x8c, 0xca, 0xd8, 0x45, 0x3b, 0x63, 0x3b, 0x1e, 0x7d, 0x75,
		0x6d, 0x3d, 0xcd, 0xac, 0x15, 0x68, 0xf6, 0xdc, 0xe6, 0x75, 0xd5, 0xf2, 0xf2, 0x68, 0x55, 0xf1,
		0x54, 0xe8, 0x4b, 0x8f, 0x87, 0x6a, 0xe5, 0x9e, 0x78, 0x57, 0xef, 0xa6, 0x64, 0x4f, 0xad, 0xdc,
		0xb1, 0x25, 0xd9, 0xad, 0xc8, 0x13, 0x21, 0x81, 0xd6, 0xd3, 0x41, 0x91, 0xb1, 0xdb, 0x21, 0x31,
		0x27, 0xaa, 0xe8, 0x18, 0xba, 0x5e, 0x4f, 0x90, 0xc4, 0x25, 0x1a, 0xdd, 0x57, 0xc5, 0x58, 0x4d,
		0xa4, 0x26, 0x32, 0x5f, 0x7e, 0xc9, 0x9e, 0xe8, 0x43, 0xd7, 0x52, 0x6a, 0x66, 0x6c, 0xa1, 0x2c,
		0xaa, 0xa3, 0x41, 0xac, 0x82, 0xd4, 0x1e, 0x20, 0x68, 0x84, 0x7f, 0xf1, 0xb9, 0xcf, 0x6e, 0x62,
		0x6d, 0xfd, 0x1c, 0x8f, 0x86, 0x68, 0x9c, 0x18, 0xdf, 0xbd, 0x15, 0x8c, 0x85, 0x29, 0x3a, 0x8d,
		0x0b, 0x7f, 0x10, 0xe6, 0x6d, 0xe8, 0x20, 0x9b, 0x6a, 0x7e, 0x22, 0xd8, 0x51, 0xdb, 0x23, 0xd2,
		0x4e, 0xe7, 0x5d, 0x65, 0xb4, 0x91, 0x90, 0x3a, 0x1c, 0x17, 0x3b, 0x9d, 0x24, 0x52, 0x27, 0x76,
		0x86, 0xeb, 0x16, 0xd9, 0x32, 0x6d, 0xed, 0xec, 0x64, 0xc8, 0xa7, 0x9d, 0x0c, 0xdd, 0x68, 0xf1,
		0xe6, 0xb3, 0x39, 0x34, 0x80, 0x73, 0x25, 0x81, 0xb1, 0xd5, 0x32, 0x91, 0x79, 0xab, 0x37, 0xef,
		0xd1, 0x5e, 0x0e, 0x9c, 0x08, 0x61, 0x35, 0x9b, 0xc3, 0xf4, 0xfd, 0x01, 0x5c, 0xb8, 0x1d, 0x0b,
		0xca, 0x41, 0x79, 0xfe, 0x09, 0x4c, 0x9b, 0x40, 0x4b, 0xd1, 0xf2, 0x0d, 0x0b, 0x01, 0xef, 0x06,
		0x3c, 0x1f, 0xf0, 0x92, 0x5f, 0x0a, 0xd4, 0xf3, 0x0c, 0x2e, 0x3c, 0x24, 0xdf, 0x07, 0xc8, 0x79,
		0x98, 0xa3, 0x07, 0x01, 0xbd, 0x70, 0x68, 0x16, 0x1d, 0xe7, 0xc8, 0x7f, 0xf2, 0x20, 0xba, 0x36,
		0x65, 0x63, 0x8c, 0xcb, 0x94, 0x8a, 0xc6, 0x8e, 0x81, 0xcc, 0xe6, 0x0c, 0xbd, 0x82, 0xcc, 0x27,
		0xbc, 0xcd, 0x43, 0x11, 0x5d, 0x47, 0x44, 0x55, 0x28, 0xae, 0x97, 0x79, 0x8c, 0xc9, 0x7e, 0xa3,
		0x6f, 0xab, 0xcc, 0xf7, 0xc6, 0x4e, 0xdb, 0xe4, 0x0a, 0x88, 0x6f, 0x45, 0x77, 0x3a, 0xd9, 0xb3,
		0xa9, 0xb3, 0x7b, 0x2b, 0x9b, 0x08, 0x65, 0x54, 0x4c, 0xd1, 0x88, 0xd1, 0xee, 0x50, 0xba, 0x12,
		0x86, 0x61, 0x22, 0xd4, 0x2a, 0xf3, 0x71, 0x44, 0xdf, 0xd5, 0xac, 0x56, 0x92, 0x36, 0xfb, 0x3f,
		0x96, 0x66, 0xa4, 0x72, 0x22, 0x14, 0x33, 0x6a, 0x8f, 0xe4, 0x2c, 0x86, 0x06, 0x0c, 0xcf, 0xab,
		0x4c, 0xe9, 0x28, 0x35, 0x99, 0x88, 0x98, 0x52, 0x1c, 0x2d, 0x2b, 0x3a, 0x08, 0x82, 0x15, 0x79,
		0x4a, 0x3c, 0xce, 0x84, 0x6e, 0x95, 0xfa, 0x03, 0x1e, 0x6d, 0xab, 0x14, 0xd3, 0x71, 0x26, 0x20,
		0x6a, 0x78, 0xf2, 0x11, 0x8a, 0xcf, 0xad, 0xeb, 0x33, 0x46, 0x74, 0x91, 0xa1, 0xe0, 0xec, 0x8a,
		0xf9, 0xac, 0x8c, 0xa5, 0xe4, 0x5f, 0x4b, 0x07, 0x22, 0x07, 0x22, 0x5b, 0x08, 0xf4, 0xcd, 0xbd,
		0x25, 0xf1, 0xef, 0x9b, 0xd2, 0x0e, 0x7f, 0x0a, 0xd6, 0x8c, 0x46, 0x2b, 0x8a, 0x58, 0x3b, 0x15,
		0x9a, 0xd3, 0x93, 0xdc, 0xdc, 0xd1, 0xdd, 0xc5, 0xc6, 0xec, 0xdd, 0x7a, 0xab, 0x43, 0x6f, 0x75,
		0x24, 0xbb, 0x12, 0x86, 0x61, 0xcc, 0xee, 0xf6, 0x1f, 0xf5, 0x33, 0x86, 0x54, 0xa4, 0xde, 0x0f,
		0x71, 0xff, 0x68, 0x2f, 0x2e, 0x64, 0x21, 0xee, 0xb5, 0x80, 0x5b, 0xf7, 0xe1, 0xc2, 0x00, 0x60,
		0x4c, 0x8f, 0x03, 0xca, 0xed, 0x43, 0xd7, 0x1e, 0x87, 0x38, 0xad, 0xf7, 0x17, 0x5b, 0x5a, 0x84,
		0x62, 0xcb, 0x3a, 0xe1, 0x8f, 0x2d, 0xdf, 0x06, 0xf9, 0x04, 0xf0, 0x77, 0x00, 0x7f, 0x57, 0xd8,
		0x45, 0xce, 0xf8, 0xdf, 0xf0, 0xbf, 0xe9, 0x3f, 0xeb, 0xff, 0x95, 0xff, 0x2d, 0xf0, 0xe9, 0xd3,
		0x7a, 0xc3, 0x36, 0xea, 0xa1, 0xf8, 0x52, 0xa9, 0xa1, 0x3f, 0xe0, 0xcd, 0xbf, 0x2d, 0xbb, 0xcb,
		0x30, 0xbd, 0x05, 0xbe, 0x8e, 0x55, 0x2d, 0x06, 0xff, 0x9e, 0xfd, 0xb8, 0x70, 0x0f, 0x2d, 0xaf,
		0x99, 0x3d, 0x5f, 0x61, 0x6a, 0x37, 0x65, 0x85, 0x29, 0x2b, 0x4d, 0xe9, 0xd1, 0xe5, 0xb7, 0x08,
		0xf7, 0x05, 0x7c, 0x81, 0x47, 0xcc, 0xe5, 0xe4, 0x91, 0x28, 0xa7, 0xb7, 0x7f, 0x8b, 0x0b, 0x0c,
		0x98, 0xff, 0x3b, 0x7b, 0x71, 0x30, 0xe2, 0x8a, 0xba, 0x9c, 0x3e, 0xad, 0x92, 0x78, 0xf3, 0x83,
		0x11, 0x8f, 0xb6, 0x85, 0x5c, 0x96, 0x2f, 0xc3, 0x5a, 0x78, 0x5f, 0xae, 0x73, 0x6b, 0x9b, 0x19,
		0xd1, 0x0b, 0xfa, 0xbe, 0x27, 0x4c, 0x2d, 0xaf, 0x6b, 0xed, 0xa6, 0x36, 0xae, 0x6b, 0x9d, 0xa6,
		0xf6, 0x9e, 0xae, 0xa5, 0x4c, 0xed, 0x92, 0xae, 0x1d, 0x89, 0x94, 0xf7, 0xb9, 0xa2, 0xdc, 0xd7,
		0xa4, 0xdc, 0x6a, 0x5a, 0x10, 0xc5, 0xa3, 0xee, 0x62, 0x42, 0x6f, 0x6b, 0xd7, 0xbf, 0x9d, 0xfa,
		0x37, 0xa5, 0x7f, 0xab, 0x4a, 0xdc, 0x32, 0xad, 0x5b, 0xa6, 0x75, 0xcb, 0xb4, 0x6e, 0x99, 0x96,
		0x1d, 0x08, 0x51, 0x57, 0x94, 0xfb, 0xbb, 0x20, 0x4f, 0xcb, 0x79, 0xe0, 0x71, 0xe0, 0xf7, 0x80,
		0x2f, 0x01, 0x83, 0xcd, 0xc9, 0xf7, 0x87, 0xe7, 0xc5, 0x01, 0x88, 0xd9, 0x10, 0xec, 0x09, 0xdf,
		0xab, 0xfb, 0x0f, 0xe0, 0xc2, 0xcf, 0x20, 0x7e, 0x95, 0xaa, 0xa8, 0x2e, 0x25, 0x65, 0xc5, 0x8b,
		0x6b, 0xa0, 0xc2, 0xfc, 0xee, 0x1f, 0x8c, 0x9f, 0x8d, 0x79, 0x67, 0x04, 0x9a, 0xf8, 0x29, 0xcf,
		0x0c, 0xc6, 0x36, 0x91, 0x3e, 0x22, 0x10, 0x9f, 0x26, 0x0e, 0x3b, 0x8a, 0xde, 0x7c, 0xea, 0xaa,
		0x38, 0xe6, 0xd1, 0x7c, 0x9a, 0x47, 0x6b, 0xb8, 0xf1, 0x19, 0xab, 0x54, 0x1d, 0xc8, 0xa7, 0x7d,
		0x18, 0x14, 0xf3, 0x0b, 0x94, 0x0f, 0x83, 0xde, 0x3c, 0xcf, 0x8b, 0x45, 0x4a, 0x25, 0xa9, 0x83,
		0xbc, 0x47, 0xc7, 0x5a, 0x1b, 0x1d, 0xc5, 0x4f, 0xc2, 0x9f, 0x86, 0x05, 0x38, 0x87, 0xb8, 0xd8,
		0xda, 0x24, 0x94, 0x96, 0x28, 0x19, 0xb5, 0xaf, 0xf9, 0xe1, 0xf0, 0x11, 0x38, 0x77, 0x90, 0x1b,
		0xbf, 0xc1, 0x85, 0xaf, 0x48, 0x57, 0x1b, 0x77, 0x36, 0x2f, 0x55, 0xe6, 0x91, 0xe7, 0x5d, 0x8c,
		0x05, 0xc3, 0xf4, 0x2c, 0xba, 0x7e, 0xae, 0xf9, 0x68, 0x60, 0x5c, 0x9a, 0x47, 0xd2, 0xcd, 0x3e,
		0xed, 0x75, 0xe9, 0x28, 0xec, 0x7d, 0xa6, 0x89, 0x35, 0xba, 0x8b, 0xab, 0xc2, 0x47, 0x03, 0x36,
		0x38, 0x87, 0xa2, 0xfa, 0x52, 0x60, 0x4f, 0xd3, 0x4a, 0xd0, 0xec, 0xd4, 0xc0, 0x5f, 0x0f, 0xef,
		0x69, 0x1a, 0x92, 0x58, 0x23, 0x2e, 0x56, 0x92, 0xa7, 0x9a, 0x0f, 0xee, 0xd3, 0xe3, 0x79, 0x19,
		0x3d, 0x8b, 0xcf, 0x1f, 0x34, 0xcf, 0xdd, 0xfe, 0xa6, 0xbd, 0x4d, 0xc6, 0x3c, 0xd3, 0x30, 0x8f,
		0x40, 0x2b, 0xfa, 0x71, 0x01, 0xd3, 0x2b, 0x10, 0x03, 0x27, 0xc4, 0x43, 0xa0, 0xb7, 0xf6, 0x70,
		0xbd, 0x04, 0xba, 0x0b, 0x62, 0x62, 0x64, 0x8d, 0x38, 0xe6, 0x26, 0x35, 0x11, 0x9f, 0xf6, 0xef,
		0x6b, 0x1d, 0x74, 0xcd, 0x8e, 0xdd, 0x36, 0x88, 0x0b, 0x4f, 0x43, 0x5f, 0x37, 0x64, 0xf7, 0x97,
		0x95, 0xae, 0x5e, 0x25, 0x95, 0xea, 0xee, 0x91, 0x93, 0x89, 0xda, 0xe8, 0x63, 0x52, 0x63, 0x6d,
		0x6f, 0xc7, 0x8e, 0x24, 0xaf, 0x00, 0x8c, 0x55, 0x83, 0x7d, 0xee, 0x7f, 0xd8, 0x37, 0xb6, 0xf7,
		0x74, 0x6f, 0x89, 0xf3, 0x1e, 0xbd, 0xc9, 0xf9, 0xc5, 0x8b, 0xe6, 0x09, 0xa8, 0x86, 0x48, 0x2d,
		0x21, 0x1d, 0xca, 0x15, 0x53, 0xb7, 0x99, 0xfa, 0x94, 0xa9, 0xdf, 0xfb, 0x0a, 0x54, 0xe4, 0x57,
		0x60, 0xf6, 0x51, 0x34, 0xf2, 0x94, 0x62, 0xab, 0xde, 0x0e, 0xfb, 0xe4, 0x7c, 0xd1, 0xd8, 0x27,
		0x17, 0xcc, 0x53, 0xdd, 0xd1, 0x95, 0x8e, 0x77, 0x76, 0x24, 0x6a, 0xe3, 0x09, 0xc8, 0xd0, 0xde,
		0x5e, 0xee, 0xbf, 0x26, 0x22, 0xaa, 0x95, 0x70, 0xea, 0xef, 0xa1, 0xe8, 0x2c, 0x8c, 0x1c, 0xae,
		0x2a, 0x8a, 0xea, 0xdd, 0xa0, 0xff, 0x90, 0xe2, 0x61, 0x3b, 0xe4, 0x73, 0xbf, 0x82, 0x4b, 0xdc,
		0xb7, 0x50, 0x72, 0x34, 0xd4, 0x39, 0x8c, 0x5a, 0xef, 0xd1, 0xfe, 0xd7, 0x18, 0x07, 0xe1, 0x63,
		0xf8, 0x29, 0x16, 0x4a, 0x42, 0x03, 0xff, 0x8f, 0x3c, 0xdf, 0x43, 0x07, 0x71, 0x61, 0xae, 0x99,
		0xfb, 0x32, 0xe0, 0x67, 0x21, 0x36, 0xb3, 0x3b, 0xf1, 0xd8, 0x31, 0x7c, 0x8e, 0xd7, 0xb7, 0xfb,
		0x22, 0x19, 0xb5, 0x7d, 0xc0, 0x88, 0xed, 0xd3, 0x64, 0xcc, 0xfd, 0xae, 0xfb, 0xbc, 0x1b, 0x6a,
		0x98, 0xc6, 0x7d, 0x69, 0x6b, 0x3a, 0xc1, 0xd2, 0xa0, 0x9d, 0x56, 0x18, 0xdc, 0x58, 0x8c, 0x9d,
		0x51, 0x2a, 0x20, 0x5f, 0xcf, 0x28, 0xbc, 0x0e, 0x9f, 0x51, 0xee, 0xd6, 0x31, 0xcf, 0x60, 0x9c,
		0x33, 0x2c, 0x5c, 0x72, 0x9b, 0x4f, 0x13, 0xe8, 0x9d, 0x43, 0xb8, 0x60, 0xa3, 0x10, 0xbd, 0x4b,
		0xa2, 0x5a, 0xb6, 0x41, 0xcc, 0x63, 0xc8, 0xe5, 0x52, 0x03, 0x54, 0xb4, 0x0d, 0x5f, 0x23, 0xe2,
		0xe8, 0xa7, 0x37, 0xbd, 0xf9, 0x9d, 0x55, 0x5d, 0x84, 0xdf, 0x67, 0xd9, 0xf3, 0x5d, 0x88, 0xb1,
		0xcb, 0x8a, 0x47, 0xe3, 0x7c, 0x61, 0x19, 0x63, 0x13, 0x20, 0x27, 0x4c, 0x0c, 0x27, 0x02, 0x56,
		0x4e, 0xde, 0xbe, 0xaa, 0x40, 0xa5, 0x01, 0x34, 0xa6, 0xa3, 0x0a, 0x88, 0xf0, 0x94, 0x8e, 0x54,
		0x68, 0x3b, 0x74, 0xfc, 0x5f, 0xe8, 0xf7, 0x30, 0xc6, 0x9b, 0x5f, 0x1e, 0xd5, 0x2b, 0x3f, 0xdc,
		0xac, 0xc9, 0x9e, 0x9e, 0xee, 0x1e, 0x66, 0xec, 0xfb, 0x8c, 0x92, 0xbe, 0x6b, 0x46, 0x89, 0x02,
		0x6f, 0x5a, 0x34, 0xa3, 0x6c, 0x00, 0xb9, 0xe5, 0xab, 0x33, 0x4a, 0x16, 0x70, 0x0c, 0xe4, 0x09,
		0x90, 0x47, 0x16, 0xa1, 0xeb, 0xaf, 0xce, 0x9e, 0xd5, 0x1b, 0x38, 0x67, 0xab, 0xc1, 0xf4, 0x1d,
		0x98, 0x2b, 0x4a, 0x3f, 0xe7, 0x33, 0x00, 0xea, 0xd3, 0xd1, 0x79, 0x40, 0x0b, 0x74, 0xf4, 0x2e,
		0xa0, 0x1f, 0xe9, 0x68, 0x0c, 0xd0, 0x33, 0x3a, 0xba, 0x08, 0x68, 0xd9, 0x17, 0xd0, 0x15, 0x40,
		0xdb, 0x75, 0x34, 0x05, 0x68, 0xa5, 0x8e, 0x3e, 0x00, 0xf4, 0x0d, 0xfa, 0xf9, 0xb2, 0x9a, 0x08,
		0xaf, 0xfa, 0x58, 0x2b, 0x35, 0xb8, 0xf4, 0x7a, 0xe3, 0x86, 0xbb, 0xfa, 0xf8, 0x1a, 0x7e, 0x97,
		0x20, 0x7a, 0x27, 0xb9, 0x23, 0x2c, 0x12, 0xac, 0xd9, 0xe8, 0xdc, 0xb0, 0x50, 0x1a, 0x5a, 0xc3,
		0xff, 0x07, 0xa6, 0xeb, 0xe0, 0x8e, 0x5c, 0x0d, 0x23, 0x19, 0x6b, 0x33, 0xef, 0xc7, 0x85, 0x6a,
		0x07, 0xe1, 0x98, 0xef, 0xdb, 0x0f, 0x62, 0xde, 0xbc, 0x81, 0xb3, 0xda, 0xc2, 0x34, 0xb7, 0xae,
		0x0f, 0xbf, 0xe0, 0x65, 0x6c, 0x38, 0xb0, 0x95, 0x3e, 0x17, 0xf0, 0x69, 0xa9, 0xd8, 0xc3, 0xe1,
		0x93, 0x2d, 0x46, 0x25, 0xdf, 0x2e, 0xd5, 0xee, 0xea, 0x0f, 0x88, 0xea, 0x1b, 0x2d, 0x33, 0x2d,
		0x1b, 0x9b, 0x87, 0x62, 0x43, 0x92, 0x13, 0x66, 0x75, 0x50, 0x34, 0x2a, 0x14, 0x7f, 0x1e, 0x13,
		0xf3, 0x87, 0x0f, 0xe3, 0x49, 0x4c, 0xf1, 0xb8, 0xa8, 0x01, 0x1a, 0xc7, 0x93, 0x7d, 0xfc, 0xd6,
		0xa1, 0xdb, 0x62, 0x9d, 0x31, 0x51, 0x5b, 0x9c, 0x46, 0x53, 0xe2, 0xe8, 0x5f, 0x6f, 0x3a, 0xc8,
		0xe9, 0xd8, 0x9f, 0x24, 0xa3, 0x2f, 0x64, 0x03, 0x7f, 0xa3, 0x40, 0x0f, 0x27, 0x5d, 0x98, 0xb6,
		0xd1, 0x43, 0xb1, 0x8f, 0xc1, 0xf2, 0xd0, 0x2f, 0xd0, 0x75, 0xc3, 0xcf, 0xfb, 0xd4, 0x18, 0xed,
		0xa2, 0x8b, 0xd3, 0x43, 0xe0, 0x1f, 0xf2, 0x98, 0xc2, 0x79, 0x9e, 0xb4, 0x83, 0x0d, 0x51, 0x06,
		0xb6, 0xfa, 0x30, 0xa2, 0x95, 0x60, 0x5d, 0x19, 0x66, 0xd4, 0x9b, 0xef, 0x26, 0x8c, 0xc6, 0x08,
		0x9e, 0xac, 0x0f, 0xbf, 0x2e, 0xf1, 0x78, 0x2c, 0x0d, 0x6f, 0x97, 0x3a, 0xc8, 0xf7, 0x81, 0x97,
		0x86, 0xc9, 0x1c, 0xc6, 0x9e, 0x8c, 0xb5, 0x0e, 0xfe, 0x2d, 0xb8, 0x37, 0x82, 0xe8, 0xee, 0xb5,
		0x58, 0xe3, 0xb6, 0xe1, 0x40, 0xed, 0xae, 0xe7, 0x02, 0xb3, 0xb1, 0xe0, 0x3d, 0xff, 0x4e, 0x3b,
		0x63, 0x78, 0x72, 0x23, 0x49, 0x98, 0x6d, 0xdb, 0xc0, 0x0f, 0x54, 0x58, 0x7d, 0xf5, 0xb7, 0x60,
		0xf5, 0x7b, 0x22, 0xed, 0x5e, 0xf3, 0x15, 0xb4, 0xa6, 0x4c, 0x68, 0x81, 0xa7, 0xd0, 0xaa, 0xff,
		0xfe, 0x14, 0x5a, 0x11, 0x5c, 0x11, 0xfc, 0x71, 0xbc, 0xbc, 0x0f, 0x6d, 0x6e, 0xad, 0x8b, 0x4a,
		0x1f, 0x05, 0xa2, 0xd2, 0x9f, 0x81, 0x3f, 0x01, 0xfe, 0x0b, 0xf0, 0xad, 0xc0, 0x8a, 0x20, 0x8e,
		0x67, 0xe3, 0xac, 0x9c, 0xda, 0xde, 0x81, 0xfb, 0x0b, 0x5e, 0x3c, 0xd9, 0xdc, 0x6a, 0xf9, 0xf9,
		0xf4, 0x17, 0xdf, 0x49, 0x76, 0x6a, 0xec, 0x4d, 0x02, 0xde, 0x88, 0xbc, 0xee, 0x7f, 0xf3, 0x08,
		0x2e, 0x2c, 0x81, 0xdc, 0x74, 0xc1, 0x4b, 0xb2, 0x51, 0xc6, 0xda, 0x2d, 0xe5, 0x35, 0x79, 0x44,
		0xbe, 0x43, 0x79, 0x42, 0xa9, 0x51, 0x92, 0xca, 0x6e, 0xe5, 0x35, 0xe5, 0x03, 0x65, 0x41, 0xfa,
		0x40, 0x5a, 0xa0, 0xbb, 0xa9, 0xf1, 0x0f, 0xe0, 0x14, 0x1d, 0xe6, 0x2f, 0xad, 0x4c, 0x9a, 0xff,
		0xe0, 0x96, 0x30, 0x2d, 0xfc, 0xa6, 0xb0, 0xc8, 0x22, 0x8b, 0x2c, 0xb2, 0xc8, 0x22, 0x8b, 0x2c,
		0xb2, 0xc8, 0x22, 0x8b, 0x2c, 0xb2, 0xc8, 0x22, 0x8b, 0x2c, 0xb2, 0xc8, 0x22, 0x8b, 0x2c, 0xb2,
		0xe8, 0xff, 0xa1, 0x7f, 0x02, 0xd6, 0x15, 0xda, 0x05, 0x00, 0x00, 0x00,

	};
	char actual[128];
	const char *expected = "patch_base;1.0;";
	int i;

	// Load extension code to BT82x
	EVE_LIB_BeginCoProList();
	EVE_CMD_DLSTART();
	EVE_CMD_LOADPATCH(0);
	EVE_LIB_WriteDataToCMD(patchdata, 2012);
	EVE_LIB_EndCoProList();
	EVE_LIB_AwaitCoProEmpty();
	EVE_LIB_GetCoProException(actual);

	// Double check that the loaded patch versions match the expected versions
	for (i=0; i < 128; i++)
	{
		if (actual[i] != expected[i]) return -1;
		if (expected[i] == '\0') break;
	}
	return 0;
}

#endif /* IS_EVE_API(5) */
