/**
 @file eve_fonts.ino
 */
/*
 * ============================================================================
 * (C) Copyright,  Bridgetek Pte. Ltd.
 * ============================================================================
 *
 * This source code ("the Software") is provided by Bridgetek Pte Ltd
 * ("Bridgetek") subject to the licence terms set out
 * http://www.ftdichip.com/FTSourceCodeLicenceTerms.htm ("the Licence Terms").
 * You must read the Licence Terms before downloading or using the Software.
 * By installing or using the Software you agree to the Licence Terms. If you
 * do not agree to the Licence Terms then do not download or use the Software.
 *
 * Without prejudice to the Licence Terms, here is a summary of some of the key
 * terms of the Licence Terms (and in the event of any conflict between this
 * summary and the Licence Terms then the text of the Licence Terms will
 * prevail).
 *
 * The Software is provided "as is".
 * There are no warranties (or similar) in relation to the quality of the
 * Software. You use it at your own risk.
 * The Software should not be used in, or for, any medical device, system or
 * appliance. There are exclusions of Bridgetek liability for certain types of loss
 * such as: special loss or damage; incidental loss or damage; indirect or
 * consequential loss or damage; loss of income; loss of business; loss of
 * profits; loss of revenue; loss of contracts; business interruption; loss of
 * the use of money or anticipated savings; loss of information; loss of
 * opportunity; loss of goodwill or reputation; and/or loss of, damage to or
 * corruption of data.
 * There is a monetary cap on Bridgetek's liability.
 * The Software may have subsequently been amended by another user and then
 * distributed by that other user ("Adapted Software").  If so that user may
 * have additional licence terms that apply to those amendments. However, Bridgetek
 * has no liability in relation to those amendments.
 * ============================================================================
 */

#include <stdint.h>
#include "eve_example.h"

const uint32_t font0_offset = 1000;  // Taken from commmand line

#ifdef __GNUC__
const uint8_t font0[] __attribute__((aligned(4))) =
#else   // __GNUC__
const uint8_t font0[] =
#endif  // __GNUC__
  /*10 characters have been converted */

  /* 148 Metric Block Begin +++  */
  /*('file properties ', 'format ', 'L1', ' stride ', 5, ' width ', 36, 'height', 58, 'address', 1000)*/
  {
    /* Widths */
    0, 36, 20, 36, 36, 36, 36, 36, 36, 36, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /* Format */
    1, 0, 0, 0,
    /* Stride */
    5, 0, 0, 0,
    /* Max Width */
    36, 0, 0, 0,
    /* Max Height */
    58, 0, 0, 0,
    /* Raw Data Address in Decimal: <858> */
    90, 3, 0, 0,

    /* 148 Metric Block End ---  */

    /*Bitmap Raw Data begin +++*/
    /*The expected raw bitmap size is 2900 Bytes */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 127, 255, 255, 192, 0, 63, 255, 255, 128, 1, 31, 255, 255, 16, 1, 143, 255, 254, 32, 1, 199, 255, 252, 96, 1, 227, 255, 248, 224, 1,
    243, 255, 241, 224, 1, 248, 0, 3, 224, 1, 248, 0, 7, 224, 1, 248, 0, 15, 224, 1, 248, 0, 15, 224, 1, 248, 0, 15, 224, 1, 248, 0,
    15, 224, 3, 248, 0, 15, 224, 3, 248, 0, 15, 224, 3, 248, 0, 15, 192, 3, 248, 0, 15, 192, 3, 240, 0, 15, 192, 3, 224, 0, 7, 192,
    3, 192, 0, 3, 192, 1, 128, 0, 1, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 3, 128,
    0, 3, 128, 7, 192, 0, 7, 128, 7, 224, 0, 31, 128, 7, 240, 0, 31, 128, 7, 240, 0, 31, 128, 7, 240, 0, 31, 128, 7, 224, 0, 63,
    128, 7, 224, 0, 63, 128, 7, 224, 0, 63, 128, 7, 224, 0, 63, 128, 15, 224, 0, 63, 128, 15, 224, 0, 63, 128, 15, 192, 0, 31, 128, 15,
    143, 255, 143, 0, 15, 31, 255, 199, 0, 14, 63, 255, 231, 0, 12, 127, 255, 243, 0, 8, 255, 255, 249, 0, 1, 255, 255, 248, 0, 7, 255, 255,
    252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 1, 128, 0, 0, 0, 3, 128, 0, 0, 0, 7, 128, 0, 0, 0, 7, 128, 0,
    0, 0, 15, 128, 0, 0, 0, 31, 128, 0, 0, 0, 63, 0, 0, 0, 0, 63, 0, 0, 0, 0, 63, 0, 0, 0, 0, 63, 0, 0, 0, 0,
    127, 0, 0, 0, 0, 127, 0, 0, 0, 0, 127, 0, 0, 0, 0, 127, 0, 0, 0, 0, 127, 0, 0, 0, 0, 127, 0, 0, 0, 0, 63, 0,
    0, 0, 0, 30, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0,
    0, 28, 0, 0, 0, 0, 62, 0, 0, 0, 0, 126, 0, 0, 0, 0, 254, 0, 0, 0, 0, 254, 0, 0, 0, 0, 254, 0, 0, 0, 0, 252,
    0, 0, 0, 0, 252, 0, 0, 0, 0, 252, 0, 0, 0, 0, 252, 0, 0, 0, 0, 252, 0, 0, 0, 1, 252, 0, 0, 0, 0, 252, 0, 0,
    0, 0, 124, 0, 0, 0, 0, 124, 0, 0, 0, 0, 60, 0, 0, 0, 0, 28, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 127, 255, 255, 192, 0, 63, 255, 255, 128, 0, 31, 255, 255, 16, 0, 15, 255, 254, 32, 0, 7, 255, 252, 96, 0, 3,
    255, 248, 224, 0, 3, 255, 241, 224, 0, 0, 0, 3, 224, 0, 0, 0, 7, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15,
    224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 192, 0, 0, 0, 15, 192, 0, 0, 0, 15, 192, 0,
    0, 0, 7, 192, 0, 15, 255, 243, 192, 0, 31, 255, 241, 128, 0, 63, 255, 248, 0, 0, 63, 255, 252, 0, 0, 63, 255, 248, 0, 1, 31, 255,
    240, 0, 3, 143, 255, 224, 0, 7, 192, 0, 0, 0, 7, 224, 0, 0, 0, 7, 240, 0, 0, 0, 7, 240, 0, 0, 0, 7, 240, 0, 0, 0,
    7, 224, 0, 0, 0, 7, 224, 0, 0, 0, 7, 224, 0, 0, 0, 7, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 192,
    0, 0, 0, 15, 143, 255, 128, 0, 15, 31, 255, 192, 0, 14, 63, 255, 224, 0, 12, 127, 255, 240, 0, 8, 255, 255, 248, 0, 1, 255, 255, 248,
    0, 7, 255, 255, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 192, 0, 63, 255, 255, 128, 0, 31, 255, 255, 16, 0, 15, 255, 254, 32, 0, 7, 255, 252, 96,
    0, 3, 255, 248, 224, 0, 3, 255, 241, 224, 0, 0, 0, 3, 224, 0, 0, 0, 7, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0,
    0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 192, 0, 0, 0, 15, 192, 0, 0, 0, 15,
    192, 0, 0, 0, 7, 192, 0, 15, 255, 243, 192, 0, 31, 255, 241, 128, 0, 63, 255, 248, 0, 0, 63, 255, 252, 0, 0, 63, 255, 248, 0, 0,
    31, 255, 241, 0, 0, 15, 255, 227, 128, 0, 0, 0, 7, 128, 0, 0, 0, 31, 128, 0, 0, 0, 31, 128, 0, 0, 0, 31, 128, 0, 0, 0,
    31, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128,
    0, 0, 0, 31, 128, 0, 15, 255, 143, 0, 0, 31, 255, 207, 0, 0, 63, 255, 231, 0, 0, 127, 255, 243, 0, 0, 255, 255, 249, 0, 1, 255,
    255, 248, 0, 7, 255, 255, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 128, 0, 0, 32, 1, 192, 0, 0, 96, 1, 192, 0,
    0, 224, 1, 224, 0, 1, 224, 1, 240, 0, 3, 224, 1, 248, 0, 7, 224, 1, 248, 0, 15, 224, 1, 248, 0, 15, 224, 1, 248, 0, 15, 224,
    1, 248, 0, 15, 224, 1, 248, 0, 15, 224, 3, 248, 0, 15, 224, 3, 248, 0, 15, 224, 3, 248, 0, 15, 192, 3, 248, 0, 15, 192, 3, 240,
    0, 15, 192, 3, 224, 0, 7, 192, 3, 207, 255, 243, 192, 1, 159, 255, 241, 128, 0, 63, 255, 248, 0, 0, 63, 255, 252, 0, 0, 63, 255, 248,
    0, 0, 31, 255, 241, 0, 0, 15, 255, 227, 128, 0, 0, 0, 7, 128, 0, 0, 0, 31, 128, 0, 0, 0, 31, 128, 0, 0, 0, 31, 128, 0,
    0, 0, 31, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0,
    63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 31, 0, 0, 0, 0, 15, 0, 0, 0, 0, 7, 0, 0, 0, 0, 3, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 192, 0, 63, 255, 255, 128, 1, 31, 255, 255, 0, 1, 143, 255, 254, 0, 1,
    199, 255, 252, 0, 1, 227, 255, 248, 0, 1, 243, 255, 240, 0, 1, 248, 0, 0, 0, 1, 248, 0, 0, 0, 1, 248, 0, 0, 0, 1, 248, 0,
    0, 0, 1, 248, 0, 0, 0, 1, 248, 0, 0, 0, 3, 248, 0, 0, 0, 3, 248, 0, 0, 0, 3, 248, 0, 0, 0, 3, 248, 0, 0, 0,
    3, 240, 0, 0, 0, 3, 224, 0, 0, 0, 3, 207, 255, 240, 0, 1, 159, 255, 240, 0, 0, 63, 255, 248, 0, 0, 63, 255, 252, 0, 0, 63,
    255, 248, 0, 0, 31, 255, 241, 0, 0, 15, 255, 227, 128, 0, 0, 0, 7, 128, 0, 0, 0, 31, 128, 0, 0, 0, 31, 128, 0, 0, 0, 31,
    128, 0, 0, 0, 31, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0,
    0, 0, 63, 128, 0, 0, 0, 31, 128, 0, 15, 255, 143, 0, 0, 31, 255, 207, 0, 0, 63, 255, 231, 0, 0, 127, 255, 243, 0, 0, 255, 255,
    249, 0, 1, 255, 255, 248, 0, 7, 255, 255, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 192, 0, 63, 255, 255, 128, 1, 31, 255, 255, 0, 1, 143, 255, 254,
    0, 1, 199, 255, 252, 0, 1, 227, 255, 248, 0, 1, 243, 255, 240, 0, 1, 248, 0, 0, 0, 1, 248, 0, 0, 0, 1, 248, 0, 0, 0, 1,
    248, 0, 0, 0, 1, 248, 0, 0, 0, 1, 248, 0, 0, 0, 3, 248, 0, 0, 0, 3, 248, 0, 0, 0, 3, 248, 0, 0, 0, 3, 248, 0,
    0, 0, 3, 240, 0, 0, 0, 3, 224, 0, 0, 0, 3, 207, 255, 240, 0, 1, 159, 255, 240, 0, 0, 63, 255, 248, 0, 0, 63, 255, 252, 0,
    0, 63, 255, 248, 0, 1, 31, 255, 241, 0, 3, 143, 255, 227, 128, 7, 192, 0, 7, 128, 7, 224, 0, 31, 128, 7, 240, 0, 31, 128, 7, 240,
    0, 31, 128, 7, 240, 0, 31, 128, 7, 224, 0, 63, 128, 7, 224, 0, 63, 128, 7, 224, 0, 63, 128, 7, 224, 0, 63, 128, 15, 224, 0, 63,
    128, 15, 224, 0, 63, 128, 15, 192, 0, 31, 128, 15, 143, 255, 143, 0, 15, 31, 255, 199, 0, 14, 63, 255, 231, 0, 12, 127, 255, 243, 0, 8,
    255, 255, 249, 0, 1, 255, 255, 248, 0, 7, 255, 255, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 192, 0, 63, 255, 255, 128, 0, 31, 255, 255, 16, 0, 15,
    255, 254, 32, 0, 7, 255, 252, 96, 0, 3, 255, 248, 224, 0, 3, 255, 241, 224, 0, 0, 0, 3, 224, 0, 0, 0, 7, 224, 0, 0, 0, 15,
    224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 224, 0, 0, 0, 15, 192, 0,
    0, 0, 15, 192, 0, 0, 0, 15, 192, 0, 0, 0, 7, 192, 0, 0, 0, 3, 192, 0, 0, 0, 1, 128, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 3, 128, 0, 0, 0, 7, 128, 0, 0, 0, 31, 128, 0, 0, 0, 31, 128,
    0, 0, 0, 31, 128, 0, 0, 0, 31, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0,
    0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 31, 0, 0, 0, 0, 15, 0, 0, 0, 0, 7, 0, 0, 0, 0, 3,
    0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 192, 0, 63, 255, 255, 128, 1, 31, 255, 255, 16,
    1, 143, 255, 254, 32, 1, 199, 255, 252, 96, 1, 227, 255, 248, 224, 1, 243, 255, 241, 224, 1, 248, 0, 3, 224, 1, 248, 0, 7, 224, 1, 248,
    0, 15, 224, 1, 248, 0, 15, 224, 1, 248, 0, 15, 224, 1, 248, 0, 15, 224, 3, 248, 0, 15, 224, 3, 248, 0, 15, 224, 3, 248, 0, 15,
    192, 3, 248, 0, 15, 192, 3, 240, 0, 15, 192, 3, 224, 0, 7, 192, 3, 207, 255, 243, 192, 1, 159, 255, 241, 128, 0, 63, 255, 248, 0, 0,
    63, 255, 252, 0, 0, 63, 255, 248, 0, 1, 31, 255, 241, 0, 3, 143, 255, 227, 128, 7, 192, 0, 7, 128, 7, 224, 0, 31, 128, 7, 240, 0,
    31, 128, 7, 240, 0, 31, 128, 7, 240, 0, 31, 128, 7, 224, 0, 63, 128, 7, 224, 0, 63, 128, 7, 224, 0, 63, 128, 7, 224, 0, 63, 128,
    15, 224, 0, 63, 128, 15, 224, 0, 63, 128, 15, 192, 0, 31, 128, 15, 143, 255, 143, 0, 15, 31, 255, 199, 0, 14, 63, 255, 231, 0, 12, 127,
    255, 243, 0, 8, 255, 255, 249, 0, 1, 255, 255, 248, 0, 7, 255, 255, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 192, 0, 63, 255, 255, 128, 1, 31, 255,
    255, 16, 1, 143, 255, 254, 32, 1, 199, 255, 252, 96, 1, 227, 255, 248, 224, 1, 243, 255, 241, 224, 1, 248, 0, 3, 224, 1, 248, 0, 7, 224,
    1, 248, 0, 15, 224, 1, 248, 0, 15, 224, 1, 248, 0, 15, 224, 1, 248, 0, 15, 224, 3, 248, 0, 15, 224, 3, 248, 0, 15, 224, 3, 248,
    0, 15, 192, 3, 248, 0, 15, 192, 3, 240, 0, 15, 192, 3, 224, 0, 7, 192, 3, 207, 255, 243, 192, 1, 159, 255, 241, 128, 0, 63, 255, 248,
    0, 0, 63, 255, 252, 0, 0, 63, 255, 248, 0, 0, 31, 255, 241, 0, 0, 15, 255, 227, 128, 0, 0, 0, 7, 128, 0, 0, 0, 31, 128, 0,
    0, 0, 31, 128, 0, 0, 0, 31, 128, 0, 0, 0, 31, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0,
    63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 63, 128, 0, 0, 0, 31, 128, 0, 15, 255, 143, 0, 0, 31, 255, 207, 0, 0, 63, 255, 231, 0,
    0, 127, 255, 243, 0, 0, 255, 255, 249, 0, 1, 255, 255, 248, 0, 7, 255, 255, 252, 0,
    /*Bitmap Raw Data end ---*/
  };


uint32_t eve_init_fonts(void) {
  const uint32_t font0_size = sizeof(font0);

  eve.LIB_WriteDataToRAMG(font0, font0_size, font0_offset);

  eve.LIB_BeginCoProList();
  eve.CMD_DLSTART();
  eve.CMD_SETFONT(FONT_CUSTOM, font0_offset, 0);
  eve.DISPLAY();
  eve.CMD_SWAP();
  eve.LIB_EndCoProList();
  eve.LIB_AwaitCoProEmpty();
  return ((font0_size + font0_offset) + 16) & (~15);
}
