/**
 * @file Bridgetek_EVE5.cpp
 * @brief Support BT820
 */
/*
 * ============================================================================
 * (C) Copyright,  Bridgetek Pte. Ltd.
 * ============================================================================
 *
 * This source code ("the Software") is provided by Bridgetek Pte Ltd
 * ("Bridgetek") subject to the licence terms set out
 * http://www.ftdichip.com/FTSourceCodeLicenceTerms.htm ("the Licence Terms").
 * You must read the Licence Terms before downloading or using the Software.
 * By installing or using the Software you agree to the Licence Terms. If you
 * do not agree to the Licence Terms then do not download or use the Software.
 *
 * Without prejudice to the Licence Terms, here is a summary of some of the key
 * terms of the Licence Terms (and in the event of any conflict between this
 * summary and the Licence Terms then the text of the Licence Terms will
 * prevail).
 *
 * The Software is provided "as is".
 * There are no warranties (or similar) in relation to the quality of the
 * Software. You use it at your own risk.
 * The Software should not be used in, or for, any medical device, system or
 * appliance. There are exclusions of Bridgetek liability for certain types of loss
 * such as: special loss or damage; incidental loss or damage; indirect or
 * consequential loss or damage; loss of income; loss of business; loss of
 * profits; loss of revenue; loss of contracts; business interruption; loss of
 * the use of money or anticipated savings; loss of information; loss of
 * opportunity; loss of goodwill or reputation; and/or loss of, damage to or
 * corruption of data.
 * There is a monetary cap on Bridgetek's liability.
 * The Software may have subsequently been amended by another user and then
 * distributed by that other user ("Adapted Software").  If so that user may
 * have additional licence terms that apply to those amendments. However, Bridgetek
 * has no liability in relation to those amendments.
 * ============================================================================
 */

#include "Arduino.h"
#include "Bridgetek_EVE5.h"

uint32_t EVE_DISP_WIDTH, EVE_DISP_HEIGHT;
uint32_t EVE_DISP_HCYCLE, EVE_DISP_VCYCLE;
uint32_t EVE_DISP_HOFFSET, EVE_DISP_VOFFSET;
uint32_t EVE_DISP_HSYNC0, EVE_DISP_HSYNC1, EVE_DISP_VSYNC0, EVE_DISP_VSYNC1;
uint32_t EVE_DISP_PCLKPOL, EVE_DISP_SWIZZLE, EVE_DISP_CSPREAD, EVE_DISP_DITHER;
uint32_t EVE_DISP_PCLK, EVE_DISP_PCLK_FREQ;
uint32_t EVE_TOUCH_ADDR;
uint32_t EVE_DISP_LVDSTXCLKDIV, EVE_DISP_LVDSTXFORMAT;
uint32_t EVE_RAM_G_CONFIG_SIZE = EVE_RAM_G_1_GBIT;

Bridgetek_EVE5::Bridgetek_EVE5(void)
{
}

void Bridgetek_EVE5::setup(uint32_t panel)
{
    setpanel(panel);
}

void Bridgetek_EVE5::setup(uint32_t panel, uint32_t ramg)
{
    setpanel(panel);
    EVE_RAM_G_CONFIG_SIZE = ramg;
}

void Bridgetek_EVE5::setpanel(uint32_t panel)
{
    if (panel == QVGA)
    {
        EVE_DISP_WIDTH = 320;
        EVE_DISP_HEIGHT = 240;
        EVE_DISP_HCYCLE = 408;
        EVE_DISP_VCYCLE = 263;
        EVE_DISP_HOFFSET = 70;
        EVE_DISP_VOFFSET = 13;
        EVE_DISP_HSYNC0 = 0;
        EVE_DISP_HSYNC1 = 10;
        EVE_DISP_VSYNC0 = 0;
        EVE_DISP_VSYNC1 = 2;
        EVE_DISP_PCLKPOL = 0;
        EVE_DISP_SWIZZLE = 2;
        EVE_DISP_CSPREAD = 0;
        EVE_DISP_DITHER = 1;
        EVE_DISP_PCLK = 8;
        EVE_DISP_PCLK_FREQ = 0x8A1;
        // Default - automatic
        EVE_TOUCH_ADDR = 0;
    }
    else if (panel == WQVGA)
    {
        EVE_DISP_WIDTH = 480;
        EVE_DISP_HEIGHT = 272;
        EVE_DISP_HCYCLE = 548;
        EVE_DISP_VCYCLE = 292;
        EVE_DISP_HOFFSET = 43;
        EVE_DISP_VOFFSET = 12;
        EVE_DISP_HSYNC0 = 0;
        EVE_DISP_HSYNC1 = 41;
        EVE_DISP_VSYNC0 = 0;
        EVE_DISP_VSYNC1 = 10;
        EVE_DISP_PCLKPOL = 1;
        EVE_DISP_SWIZZLE = 0;
        EVE_DISP_CSPREAD = 0;
        EVE_DISP_DITHER = 1;
        EVE_DISP_PCLK = 5;
        EVE_DISP_PCLK_FREQ = 0x8A1;
        // Default - automatic
        EVE_TOUCH_ADDR = 0;
    }
    else if (panel == WVGA)
    {
        EVE_DISP_WIDTH = 800;
        EVE_DISP_HEIGHT = 480;
        EVE_DISP_HCYCLE = 928;
        EVE_DISP_VCYCLE = 525;
        EVE_DISP_HOFFSET = 88;
        EVE_DISP_VOFFSET = 32;
        EVE_DISP_HSYNC0 = 0;
        EVE_DISP_HSYNC1 = 48;
        EVE_DISP_VSYNC0 = 0;
        EVE_DISP_VSYNC1 = 3;
        EVE_DISP_PCLKPOL = 1;
        EVE_DISP_SWIZZLE = 0;
        EVE_DISP_CSPREAD = 0;
        EVE_DISP_DITHER = 1;
        EVE_DISP_PCLK = 2;
        EVE_DISP_PCLK_FREQ = 0x8A1;
        // Default - automatic
        EVE_TOUCH_ADDR = 0;
    }
    else if (panel == WSVGA)
    {
        EVE_DISP_WIDTH = 1024;
        EVE_DISP_HEIGHT = 600;
        EVE_DISP_HCYCLE = 1344;
        EVE_DISP_VCYCLE = 635;
        EVE_DISP_HOFFSET = 160;
        EVE_DISP_VOFFSET = 23;
        EVE_DISP_HSYNC0 = 0;
        EVE_DISP_HSYNC1 = 100;
        EVE_DISP_VSYNC0 = 0;
        EVE_DISP_VSYNC1 = 10;
        EVE_DISP_PCLKPOL = 1;
        EVE_DISP_SWIZZLE = 0;
        EVE_DISP_CSPREAD = 0;
        EVE_DISP_DITHER = 1;
        EVE_DISP_PCLK = 1;
        EVE_DISP_PCLK_FREQ = 0xd12;
        // Default - automatic
        EVE_TOUCH_ADDR = 0;
    }
    else if (panel == WXGA)
    {
        EVE_DISP_WIDTH = 1280;
        EVE_DISP_HEIGHT = 800;
        EVE_DISP_HCYCLE = 1411;
        EVE_DISP_VCYCLE = 815;
        EVE_DISP_HOFFSET = 120;
        EVE_DISP_VOFFSET = 14;
        EVE_DISP_HSYNC0 = 0;
        EVE_DISP_HSYNC1 = 100;
        EVE_DISP_VSYNC0 = 0;
        EVE_DISP_VSYNC1 = 10;
        EVE_DISP_PCLKPOL = 0;
        EVE_DISP_SWIZZLE = 0;
        EVE_DISP_CSPREAD = 0;
        EVE_DISP_DITHER = 0;
        EVE_DISP_PCLK = 1;
        EVE_DISP_PCLK_FREQ = 0x8B1;
        // Default - automatic
        EVE_TOUCH_ADDR = 0;
    }
    else if (panel == FULLHD)
    {
        EVE_DISP_WIDTH = 1920;
        EVE_DISP_HEIGHT = 1080;
        EVE_DISP_HCYCLE = 2140;
        EVE_DISP_VCYCLE = 1108;
        EVE_DISP_HOFFSET = 220;
        EVE_DISP_VOFFSET = 28;
        EVE_DISP_HSYNC0 = 0;
        EVE_DISP_HSYNC1 = 20;
        EVE_DISP_VSYNC0 = 0;
        EVE_DISP_VSYNC1 = 4;
        EVE_DISP_PCLKPOL = 0;
        EVE_DISP_SWIZZLE = 0;
        EVE_DISP_CSPREAD = 0;
        EVE_DISP_DITHER = 1;
        EVE_DISP_PCLK = 1;
        EVE_DISP_PCLK_FREQ = 0x8B1;
        // Default - automatic
        EVE_TOUCH_ADDR = 0;
    }
    else if (panel == WUXGA)
    {
        EVE_DISP_WIDTH = 1920;
        EVE_DISP_HEIGHT = 1200;
        EVE_DISP_HCYCLE = (1920 + 180);
        EVE_DISP_VCYCLE = (1200 + 45);
        EVE_DISP_HOFFSET = 50;
        EVE_DISP_VOFFSET = 10;
        EVE_DISP_HSYNC0 = 0;
        EVE_DISP_HSYNC1 = 30;
        EVE_DISP_VSYNC0 = 0;
        EVE_DISP_VSYNC1 = 3;
        EVE_DISP_PCLKPOL = 0;
        EVE_DISP_SWIZZLE = 0;
        EVE_DISP_CSPREAD = 0;
        EVE_DISP_DITHER = 1;
        EVE_DISP_PCLK_FREQ = 0x8B1;
        // Default - automatic
        EVE_TOUCH_ADDR = 0;
    }
    else if (panel == WQVGAR)
    {
        EVE_DISP_WIDTH = 480;
        EVE_DISP_HEIGHT = 480;
        EVE_DISP_HCYCLE = 578;
        EVE_DISP_VCYCLE = 576;
        EVE_DISP_HOFFSET = 40;
        EVE_DISP_VOFFSET = 12;
        EVE_DISP_HSYNC0 = 0;
        EVE_DISP_HSYNC1 = 40;
        EVE_DISP_VSYNC0 = 0;
        EVE_DISP_VSYNC1 = 10;
        EVE_DISP_PCLKPOL = 0;
        EVE_DISP_SWIZZLE = 0;
        EVE_DISP_CSPREAD = 0;
        EVE_DISP_DITHER = 1;
        EVE_DISP_PCLK_FREQ = 0x8A1;
        // Default - automatic
        EVE_TOUCH_ADDR = 0;
    }
    else
    {
        // Panel type not defined.
        Serial.print("ERROR: No panel selected!\n");
    }

    EVE_DISP_LVDSTXCLKDIV = 3;
    EVE_DISP_LVDSTXFORMAT = EVE_FORMAT_RGB6;
}
