/**
 * @file EVE_config.h
 * @brief Support BT880/BT881/BT882/BT883
 */
/*
 * ============================================================================
 * (C) Copyright,  Bridgetek Pte. Ltd.
 * ============================================================================
 *
 * This source code ("the Software") is provided by Bridgetek Pte Ltd
 * ("Bridgetek") subject to the licence terms set out
 * http://www.ftdichip.com/FTSourceCodeLicenceTerms.htm ("the Licence Terms").
 * You must read the Licence Terms before downloading or using the Software.
 * By installing or using the Software you agree to the Licence Terms. If you
 * do not agree to the Licence Terms then do not download or use the Software.
 *
 * Without prejudice to the Licence Terms, here is a summary of some of the key
 * terms of the Licence Terms (and in the event of any conflict between this
 * summary and the Licence Terms then the text of the Licence Terms will
 * prevail).
 *
 * The Software is provided "as is".
 * There are no warranties (or similar) in relation to the quality of the
 * Software. You use it at your own risk.
 * The Software should not be used in, or for, any medical device, system or
 * appliance. There are exclusions of Bridgetek liability for certain types of loss
 * such as: special loss or damage; incidental loss or damage; indirect or
 * consequential loss or damage; loss of income; loss of business; loss of
 * profits; loss of revenue; loss of contracts; business interruption; loss of
 * the use of money or anticipated savings; loss of information; loss of
 * opportunity; loss of goodwill or reputation; and/or loss of, damage to or
 * corruption of data.
 * There is a monetary cap on Bridgetek's liability.
 * The Software may have subsequently been amended by another user and then
 * distributed by that other user ("Adapted Software").  If so that user may
 * have additional licence terms that apply to those amendments. However, Bridgetek
 * has no liability in relation to those amendments.
 * ============================================================================
 */

#ifndef _EVE_CONFIG_H_
#define _EVE_CONFIG_H_

// Default platform selection
#ifndef EVE_API
#define EVE_API 2
#ifndef EVE_SUB_API
#define EVE_SUB_API 2
#endif // EVE_SUB_API
#endif // EVE_API

// Definitions used for target display resolution selection
#define QVGA    320        // 320x240   e.g. VM800B with 3.5 inch display
#define WQVGA   480        // 480x272   e.g. IDM2040-43A with 4.3 inch display
#define WQVGAR  480480     // 480x480   e.g. IDM2040-21R with 2.1 inch round display
#define WVGA    800        // 800x480   e.g. ME813A-WH50C with 5 inch display
#define WSVGA   1024       // 1024x600  e.g. ME817EV with 7 inch display
#define WXGA    1280       // 1280x800  e.g. ME817EV with 10.1 inch display
#define FULLHD  1920       // 1920x1080 e.g. BT820 with 15 inch high definition display
#define WUXGA   19201200   // 1920x1200 e.g. BT820 with 10 inch high definition display

// Predefined module displays
#define VM800B     QVGA    // VM800B35A-BK with 3.5 inch display
#define VM800C35A  QVGA    // VM800C35A-D with 3.5 inch display
#define VM800C43A  WQVGA   // VM800C43A-D with 4.3 inch display
#define VM800C50A  WQVGA   // VM800C50A-D with 4.3 inch display
#define VM810C     WVGA    // VM810C50A-D with 5 inch display
#define ME812A     WVGA    // ME812A-WH50R, ME812AU-WH50R with 5 inch display
#define ME813A     WVGA    // ME813A-WH50C with 5 inch display
#define VM816C     WVGA    // VM816C50A-D, VM816CU50A-D with 5 inch display
#define IDM204021R WQVGAR  // IDM2040-21R (FT8XX_TYPE is FT800)
#define IDM204043A WQVGA   // IDM2040-43A (FT8XX_TYPE is BT883)
#define IDM20407A  WVGA    // IDM2040-7A (FT8XX_TYPE is BT817)

// Definitions used for touch controllers
#define TOUCH_ADDR_FOCALTECH 0x38 // Focaltech FT5206
#define TOUCH_TYPE_FOCALTECH 1
#define TOUCH_ADDR_GOODIX 0x5d // Goodix GT911
#define TOUCH_TYPE_GOODIX 2

// Select the touchscreen automatically
#undef EVE_TOUCH_ADDR
#undef EVE_TOUCH_TYPE

// Explicitly disable QuadSPI
#ifdef QUADSPI_ENABLE
#undef QUADSPI_ENABLE
#endif


// Setup default parameters for various displays.
// These can be overridden for different display modules.
#define SET_PCLK_FREQ

// Variables used for panel configuration.
extern uint32_t EVE_DISP_WIDTH, EVE_DISP_HEIGHT;
extern uint32_t EVE_DISP_HCYCLE, EVE_DISP_VCYCLE;
extern uint32_t EVE_DISP_HOFFSET, EVE_DISP_VOFFSET;
extern uint32_t EVE_DISP_HSYNC0, EVE_DISP_HSYNC1, EVE_DISP_VSYNC0, EVE_DISP_VSYNC1;
extern uint32_t EVE_DISP_PCLKPOL, EVE_DISP_SWIZZLE, EVE_DISP_CSPREAD, EVE_DISP_DITHER;
extern uint32_t EVE_DISP_PCLK, EVE_DISP_PCLK_FREQ;
extern uint32_t EVE_TOUCH_ADDR;

#endif /* _EVE_CONFIG_H_ */
