/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Set value with zone
@file   vscp_evt_setvaluezone.c
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
@see vscp_evt_setvaluezone.h

This file is automatically generated. Don't change it manually.

*******************************************************************************/

/*******************************************************************************
    INCLUDES
*******************************************************************************/
#include "vscp_evt_setvaluezone.h"
#include "../core/vscp_core.h"
#include "../core/vscp_class_l1.h"
#include "../core/vscp_type_setvaluezone.h"

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

/**
 * General event
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendGeneralEvent(void)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_GENERAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 0;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Count
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendCount(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_COUNT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Length/Distance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendLengthDistance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_LENGTH, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Mass
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendMass(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_MASS, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Time
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendTime(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_TIME, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electric Current
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricCurrent(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ELECTRIC_CURRENT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Temperature
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendTemperature(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_TEMPERATURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Amount of substance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendAmountOfSubstance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_AMOUNT_OF_SUBSTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous Intensity (Intensity of light)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendLuminousIntensityIntensityOfLight(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_INTENSITY_OF_LIGHT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Frequency
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendFrequency(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_FREQUENCY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radioactivity and other random events
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRadioactivityAndOtherRandomEvents(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_RADIOACTIVITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Force
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendForce(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_FORCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Pressure
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendPressure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_PRESSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Energy
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendEnergy(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Power
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendPower(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Charge
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricalCharge(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ELECTRICAL_CHARGE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Potential (Voltage)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricalPotentialVoltage(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ELECTRICAL_POTENTIAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Capacitance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricalCapacitance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ELECTRICAL_CAPACITANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Resistance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricalResistance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ELECTRICAL_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Conductance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricalConductance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ELECTRICAL_CONDUCTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Field Strength
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendMagneticFieldStrength(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_MAGNETIC_FIELD_STRENGTH, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Flux
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendMagneticFlux(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_MAGNETIC_FLUX, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Flux Density
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendMagneticFluxDensity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_MAGNETIC_FLUX_DENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Inductance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendInductance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_INDUCTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous Flux
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendLuminousFlux(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_FLUX_OF_LIGHT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Illuminance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendIlluminance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ILLUMINANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiation dose
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRadiationDose(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_RADIATION_DOSE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Catalytic activity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendCatalyticActivity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_CATALYTIC_ACITIVITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Volume
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendVolume(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_VOLUME, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound intensity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundIntensity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_SOUND_INTENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Angle
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendAngle(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ANGLE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Position WGS 84
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendPositionWgs84(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_POSITION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Speed
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSpeed(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_SPEED, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Acceleration
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendAcceleration(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ACCELERATION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Tension
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendTension(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_TENSION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Damp/moist (Hygrometer reading)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendDampMoistHygrometerReading(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_HUMIDITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Flow
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendFlow(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_FLOW, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Thermal resistance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendThermalResistance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_THERMAL_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Refractive (optical) power
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRefractiveOpticalPower(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_REFRACTIVE_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Dynamic viscosity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendDynamicViscosity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_DYNAMIC_VISCOSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound impedance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundImpedance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_SOUND_IMPEDANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound resistance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundResistance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_SOUND_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electric elastance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricElastance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ELECTRIC_ELASTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous energy
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendLuminousEnergy(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_LUMINOUS_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendLuminance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_LUMINANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Chemical (molar) concentration
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendChemicalMolarConcentration(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_CHEMICAL_CONCENTRATION_MOLAR, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/* "Chemical (mass) concentration" not supported. No frame defined. */

/**
 * Reserved
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendReserved(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_RESERVED47, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/* "Reserved" not supported. No frame defined. */

/**
 * Dew Point
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendDewPoint(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_DEWPOINT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Relative Level
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRelativeLevel(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_RELATIVE_LEVEL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Altitude
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendAltitude(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_ALTITUDE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Area
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendArea(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_AREA, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiant intensity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRadiantIntensity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_RADIANT_INTENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRadiance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_RADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Irradiance, Exitance, Radiosity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendIrradianceExitanceRadiosity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_IRRADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Spectral radiance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSpectralRadiance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_SPECTRAL_RADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Spectral irradiance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSpectralIrradiance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_SPECTRAL_IRRADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound pressure (acoustic pressure)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundPressureAcousticPressure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_SOUND_PRESSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound energy density
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundEnergyDensity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_SOUND_DENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound level
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundLevel(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    if ((NULL == data) || (0 == dataSize))
    {
        return FALSE;
    }

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_SETVALUEZONE, VSCP_TYPE_SETVALUEZONE_SOUND_LEVEL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    txMsg.data[3] = dataCoding;
    size += 1;

    for(byteIndex = 0; byteIndex < dataSize; ++byteIndex)
    {
        txMsg.data[4 + byteIndex] = data[byteIndex];
        size += 1;

        if (VSCP_L1_DATA_SIZE <= size)
        {
            break;
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

