/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Single precision floating point measurement
@file   vscp_evt_measurement32.c
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
@see vscp_evt_measurement32.h

This file is automatically generated. Don't change it manually.

*******************************************************************************/

/*******************************************************************************
    INCLUDES
*******************************************************************************/
#include "vscp_evt_measurement32.h"
#include "../core/vscp_core.h"
#include "../core/vscp_class_l1.h"
#include "../core/vscp_type_measurement32.h"

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

/**
 * General event
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendGeneralEvent(void)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_GENERAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 0;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Count
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendCount(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_COUNT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Length/Distance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendLengthDistance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_LENGTH, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Mass
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendMass(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_MASS, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Time
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendTime(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_TIME, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electric Current
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendElectricCurrent(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ELECTRIC_CURRENT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Temperature
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendTemperature(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_TEMPERATURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Amount of substance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendAmountOfSubstance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_AMOUNT_OF_SUBSTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous Intensity (Intensity of light)
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendLuminousIntensityIntensityOfLight(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_INTENSITY_OF_LIGHT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Frequency
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendFrequency(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_FREQUENCY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radioactivity and other random events
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendRadioactivityAndOtherRandomEvents(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_RADIOACTIVITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Force
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendForce(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_FORCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Pressure
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendPressure(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_PRESSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Energy
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendEnergy(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Power
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendPower(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Charge
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendElectricalCharge(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ELECTRICAL_CHARGE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Potential (Voltage)
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendElectricalPotentialVoltage(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ELECTRICAL_POTENTIAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Capacitance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendElectricalCapacitance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ELECTRICAL_CAPACITANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Resistance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendElectricalResistance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ELECTRICAL_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Conductance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendElectricalConductance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ELECTRICAL_CONDUCTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Field Strength
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendMagneticFieldStrength(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_MAGNETIC_FIELD_STRENGTH, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Flux
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendMagneticFlux(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_MAGNETIC_FLUX, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Flux Density
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendMagneticFluxDensity(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_MAGNETIC_FLUX_DENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Inductance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendInductance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_INDUCTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous Flux
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendLuminousFlux(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_FLUX_OF_LIGHT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Illuminance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendIlluminance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ILLUMINANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiation dose (absorbed)
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendRadiationDoseAbsorbed(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_RADIATION_DOSE_ABSORBED, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Catalytic activity
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendCatalyticActivity(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_CATALYTIC_ACITIVITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Volume
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendVolume(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_VOLUME, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound intensity
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendSoundIntensity(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_SOUND_INTENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Angle
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendAngle(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ANGLE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Position WGS 84
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendPositionWgs84(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_POSITION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Speed
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendSpeed(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_SPEED, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Acceleration
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendAcceleration(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ACCELERATION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Tension
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendTension(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_TENSION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Damp/moist (Hygrometer reading)
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendDampMoistHygrometerReading(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_HUMIDITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Flow
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendFlow(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_FLOW, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Thermal resistance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendThermalResistance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_THERMAL_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Refractive (optical) power
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendRefractiveOpticalPower(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_REFRACTIVE_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Dynamic viscosity
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendDynamicViscosity(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_DYNAMIC_VISCOSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound impedance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendSoundImpedance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_SOUND_IMPEDANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound resistance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendSoundResistance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_SOUND_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electric elastance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendElectricElastance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ELECTRIC_ELASTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous energy
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendLuminousEnergy(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_LUMINOUS_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendLuminance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_LUMINANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Chemical (molar) concentration
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendChemicalMolarConcentration(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_CHEMICAL_CONCENTRATION_MOLAR, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/* "Chemical (mass) concentration" not supported. No frame defined. */

/**
 * Reserved
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendReserved(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_RESERVED47, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/* "Reserved" not supported. No frame defined. */

/**
 * Dew Point
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendDewPoint(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_DEWPOINT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Relative Level
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendRelativeLevel(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_RELATIVE_LEVEL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Altitude
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendAltitude(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_ALTITUDE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Area
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendArea(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_AREA, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiant intensity
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendRadiantIntensity(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_RADIANT_INTENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendRadiance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_RADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Irradiance, Exitance, Radiosity
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendIrradianceExitanceRadiosity(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_IRRADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Spectral radiance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendSpectralRadiance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_SPECTRAL_RADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Spectral irradiance
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendSpectralIrradiance(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_SPECTRAL_IRRADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound pressure (acoustic pressure)
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendSoundPressureAcousticPressure(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_SOUND_PRESSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound energy density
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendSoundEnergyDensity(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_SOUND_DENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound level
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendSoundLevel(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_SOUND_LEVEL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiation dose (equivalent)
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendRadiationDoseEquivalent(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_DOSE_EQUIVALENT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiation dose (exposure)
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendRadiationDoseExposure(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_RADIATION_DOSE_EXPOSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Power factor
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendPowerFactor(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_POWER_FACTOR, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Reactive Power
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendReactivePower(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_REACTIVE_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Reactive Energy
 * 
 * @param[in] value The value is a "float" - IEEE-754, 32 Bits, single precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement32_sendReactiveEnergy(float_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT32, VSCP_TYPE_MEASUREMENT32_REACTIVE_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[3];
    txMsg.data[1] = ((uint8_t*)&value)[2];
    txMsg.data[2] = ((uint8_t*)&value)[1];
    txMsg.data[3] = ((uint8_t*)&value)[0];
    size += 4;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

