/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Display
@file   vscp_evt_display.h
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
This is generic display related functionality. Show info on a screen, LED-display diode, etc.

This file is automatically generated. Don't change it manually.

*******************************************************************************/

#ifndef __VSCP_EVT_DISPLAY_H__
#define __VSCP_EVT_DISPLAY_H__

/*******************************************************************************
    INCLUDES
*******************************************************************************/
#include <stdint.h>
#include "../user/vscp_platform.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

/**
 * General event
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_display_sendGeneralEvent(void);

/**
 * Clear Display
 * 
 * @param[in] code Code - not yet defined.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_display_sendClearDisplay(uint8_t code, uint8_t zone, uint8_t subZone);

/**
 * Position cursor
 * 
 * @param[in] index Index.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] row Row to move to (first row is 0).
 * @param[in] column Column to move to (first column is 0).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_display_sendPositionCursor(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t row, uint8_t column);

/**
 * Write Display
 * 
 * @param[in] index Increase by one for each event sent for specific text to display.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] data Display data. (array[5])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_display_sendWriteDisplay(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const data, uint8_t dataSize);

/**
 * Write Display buffer
 * 
 * @param[in] index Increase by one for each event sent for specific text to display.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] data Display data. (array[5])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_display_sendWriteDisplayBuffer(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const data, uint8_t dataSize);

/**
 * Show Display Buffer
 * 
 * @param[in] index Increase by one for each event sent for specific text to display.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_display_sendShowDisplayBuffer(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Set Display Buffer Parameter
 * 
 * @param[in] index Display parameter index.
 * @param[in] coding Data coding byte as of VSCP Specification.
 * @param[in] data Data as of coding. (array[6])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_display_sendSetDisplayBufferParameter(uint8_t index, uint8_t coding, uint8_t const * const data, uint8_t dataSize);

/**
 * Show Text
 * 
 * @param[in] index Increase by one for each event sent for specific text to display.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] event Event. (array[5])
 * @param[in] eventsize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_display_sendShowText(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const event, uint8_t eventSize);

/**
 * Set LED
 * 
 * @param[in] index Increase by one for each event sent for specific text to display.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] state 0 =off, 1=on, 2=blink
 * @param[in] blinkOnPeriod Blink On period in milliseconds.
 * @param[in] blinkOffPeriod Blink Off period in milliseconds.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_display_sendSetLed(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t state, uint16_t blinkOnPeriod, uint16_t blinkOffPeriod);

/**
 * Set RGB Color
 * 
 * @param[in] index Increase by one for each event sent for specific text to display.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] red Color R to display 0-255.
 * @param[in] green Color G to display 0-255.
 * @param[in] blue Color B to display 0-255.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_display_sendSetRgbColor(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t red, uint8_t green, uint8_t blue);

#ifdef __cplusplus
}
#endif

#endif  /* __VSCP_EVT_DISPLAY_H__ */
