/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  IR Remote I/f
@file   vscp_type_ir.h
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
This is the IR code sent/received from common remote controls.

This file is automatically generated. Don't change it manually.

*******************************************************************************/

#ifndef __VSCP_TYPE_IR_H__
#define __VSCP_TYPE_IR_H__

/** @defgroup vscp_type_ir IR Remote I/f
 * Level 1 protocol class types
 * @{
 * @ingroup vscp_l1
 */

/*******************************************************************************
    INCLUDES
*******************************************************************************/

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/**
 * General Event.
 */
#define VSCP_TYPE_REMOTE_GENERAL 0

/**
 * A RC5 remote code. [http://www.xs4all.nl/~sbp/knowledge/ir/sirc.htm ]Use the VSCP abstract remote
 * format if possible.
 */
#define VSCP_TYPE_REMOTE_RC5     1

/**
 * A SONY remote code. [http://www.xs4all.nl/~sbp/knowledge/ir/sirc.htm] Use the VSCP abstract remote
 * format if possible.
 */
#define VSCP_TYPE_REMOTE_SONY12  3

/**
 * Packed LIRC codes code. LRC Codes are normally sent as 64-bit codes or even larger codes. Only
 * codes with a length less then 56 bits (7-bytes) are supported by VSCP and the most significant byte
 * of the LIRC code is not transferred. http://www.lirc.org/
 */
#define VSCP_TYPE_REMOTE_LIRC    32

/**
 * Instead of sending codes that relates to a certain remote this format is general. And therefore
 * more flexible
 */
#define VSCP_TYPE_REMOTE_VSCP    48

/**
 * Instead of sending codes that relates to a certain remote this format is general. And therefore
 * more flexible.
 */
#define VSCP_TYPE_REMOTE_MAPITO  49

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* __VSCP_TYPE_IR_H__ */

/** @} */
