/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Information
@file   vscp_evt_information.h
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
Most of the events below have an index parameter that can be used to indicate which of several SECO
(sensor/control) units on a node originated the event. Set to zero if the node only control one
item.

This file is automatically generated. Don't change it manually.

*******************************************************************************/

#ifndef __VSCP_EVT_INFORMATION_H__
#define __VSCP_EVT_INFORMATION_H__

/*******************************************************************************
    INCLUDES
*******************************************************************************/
#include <stdint.h>
#include "../user/vscp_platform.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

/**
 * General event
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendGeneralEvent(void);

/**
 * Button
 * 
 * @param[in] buttonState Button state.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] buttonCode Button code.
 * @param[in] codePage Code page. (optional)
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendButton(uint8_t buttonState, uint8_t zone, uint8_t subZone, uint16_t buttonCode, uint16_t const * const codePage);

/**
 * Mouse
 * 
 * @param[in] kindOfCoordinates If zero absolute coordinates follow. If equal to one relative
 * coordinates follow.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] normalizedXCoordinate Normalized x-coordinate.
 * @param[in] normalizedYCoordinate Normalized y-coordinate.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendMouse(uint8_t kindOfCoordinates, uint8_t zone, uint8_t subZone, uint16_t normalizedXCoordinate, uint16_t normalizedYCoordinate);

/**
 * On
 * 
 * @param[in] index Index, often used as an index for channels within a module.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendOn(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Off
 * 
 * @param[in] index Index, often used as an index for channels within a module.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendOff(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Alive
 * 
 * @param[in] userSpecific User specific value.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendAlive(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Terminating
 * 
 * @param[in] userSpecific User specific value.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendTerminating(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Opened
 * 
 * @param[in] userSpecific User specific value.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendOpened(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Closed
 * 
 * @param[in] userSpecific User specific value.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendClosed(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Node Heartbeat
 * 
 * @param[in] userSpecific User specific value.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] userData Optional user provided data. (optional) (array[5])
 * @param[in] userDatasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendNodeHeartbeat(uint8_t userSpecific, uint8_t zone, uint8_t subZone, uint8_t const * const userData, uint8_t userDataSize);

/**
 * Below limit
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendBelowLimit(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Above limit
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendAboveLimit(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Pulse
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendPulse(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Error
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendError(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Resumed
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendResumed(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Paused
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendPaused(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Sleeping
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendSleeping(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Good morning
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendGoodMorning(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Good day
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendGoodDay(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Good afternoon
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendGoodAfternoon(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Good evening
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendGoodEvening(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Good night
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendGoodNight(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * See you soon
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendSeeYouSoon(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Goodbye
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendGoodbye(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Stop
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendStop(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Start
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendStart(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * ResetCompleted
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendResetcompleted(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Interrupted
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendInterrupted(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * PreparingToSleep
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendPreparingtosleep(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * WokenUp
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendWokenup(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Dusk
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendDusk(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Dawn
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendDawn(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Active
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendActive(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Inactive
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendInactive(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Busy
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendBusy(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Idle
 * 
 * @param[in] reserved Reserved for future use.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendIdle(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Stream Data
 * 
 * @param[in] sequenceNumber Sequence number which is increased by one for every new event with stream
 * data. The sequence number is increased for every frame sent going from 0 - 255 and back to 0 and so
 * on if needed. A new stream starts with a sequence number of 0.
 * @param[in] streamData Stream data. (array[7])
 * @param[in] streamDatasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendStreamData(uint8_t sequenceNumber, uint8_t const * const streamData, uint8_t streamDataSize);

/**
 * Token Activity
 * 
 * @param[in] tokenType Bit 0,1 - Event code. Bit 2-7 - Token device type code.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] frameIndex Frame index (Increase by one for every frame sent out for one token activity.
 * Start with zero ).
 * @param[in] tokenData Token data. (array[4])
 * @param[in] tokenDatasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendTokenActivity(uint8_t tokenType, uint8_t zone, uint8_t subZone, uint8_t frameIndex, uint8_t const * const tokenData, uint8_t tokenDataSize);

/**
 * Stream Data with zone
 * 
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] sequenceNumber Sequence number which is increased by one for every new event with stream
 * data. The sequence number is increased for every frame sent going from 0 - 255 and back to 0 and so
 * on if needed. A new stream starts with a sequence number of 0.
 * @param[in] streamData Stream data. (array[4])
 * @param[in] streamDatasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendStreamDataWithZone(uint8_t zone, uint8_t subZone, uint8_t sequenceNumber, uint8_t const * const streamData, uint8_t streamDataSize);

/**
 * Confirm
 * 
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] sequenceNumber Sequence number.
 * @param[in] vscpClass VSCP class.
 * @param[in] vscpType VSCP type.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendConfirm(uint8_t zone, uint8_t subZone, uint8_t sequenceNumber, uint16_t vscpClass, uint16_t vscpType);

/**
 * Level Changed
 * 
 * @param[in] level Relative or absolute level.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendLevelChanged(uint8_t level, uint8_t zone, uint8_t subZone);

/**
 * Warning
 * 
 * @param[in] level Relative or absolute level.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendWarning(uint8_t level, uint8_t zone, uint8_t subZone);

/**
 * State
 * 
 * @param[in] userSpecific User specific value.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] from State changed from (old state).
 * @param[in] to State changed to (new state).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendState(uint8_t userSpecific, uint8_t zone, uint8_t subZone, uint8_t from, uint8_t to);

/**
 * Action Trigger
 * 
 * @param[in] actionId Action id.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendActionTrigger(uint8_t actionId, uint8_t zone, uint8_t subZone);

/**
 * Sunrise
 * 
 * @param[in] userSpecific User specific value.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendSunrise(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Sunset
 * 
 * @param[in] userSpecific User specific value.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendSunset(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Start of record
 * 
 * @param[in] index Index for record.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] remainingFrames Number of frames to follow or zero for not used.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendStartOfRecord(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t remainingFrames);

/**
 * End of record
 * 
 * @param[in] index Index for record.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendEndOfRecord(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Pre-set active
 * 
 * @param[in] user User specified.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] preSetCode Code for pre-set that has been set.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendPreSetActive(uint8_t user, uint8_t zone, uint8_t subZone, uint8_t preSetCode);

/**
 * Detect
 * 
 * @param[in] index Index.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendDetect(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Overflow
 * 
 * @param[in] index Index.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendOverflow(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Big level changed
 * 
 * @param[in] index Index.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] level Level as signed Integer. The range can be adjusted by the user by sending the
 * needed number of bytes 1-5. (array[5])
 * @param[in] levelsize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendBigLevelChanged(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const level, uint8_t levelSize);

/**
 * Civil sunrise twilight time
 * 
 * @param[in] userSpecific User specific.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendCivilSunriseTwilightTime(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Civil sunset twilight time
 * 
 * @param[in] userSpecific User specific.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendCivilSunsetTwilightTime(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Nautical sunrise twilight time
 * 
 * @param[in] userSpecific User specific.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendNauticalSunriseTwilightTime(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Nautical sunset twilight time
 * 
 * @param[in] userSpecific User specific.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendNauticalSunsetTwilightTime(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Astronomical sunrise twilight time
 * 
 * @param[in] userSpecific User specific.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendAstronomicalSunriseTwilightTime(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Astronomical sunset twilight time
 * 
 * @param[in] userSpecific User specific.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendAstronomicalSunsetTwilightTime(uint8_t userSpecific, uint8_t zone, uint8_t subZone);

/**
 * Calculated Noon
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendCalculatedNoon(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Shutter up
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendShutterUp(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Shutter down
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendShutterDown(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Shutter left
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendShutterLeft(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Shutter right
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendShutterRight(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Shutter reached top end
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendShutterReachedTopEnd(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Shutter reached bottom end
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendShutterReachedBottomEnd(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Shutter reached middle end
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendShutterReachedMiddleEnd(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Shutter reached preset end
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendShutterReachedPresetEnd(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Shutter reached preset left
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendShutterReachedPresetLeft(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Shutter reached preset right
 * 
 * @param[in] reserved Reserved.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendShutterReachedPresetRight(uint8_t reserved, uint8_t zone, uint8_t subZone);

/**
 * Long click
 * 
 * @param[in] index Index for device generating long click. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendLongClick(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Single click
 * 
 * @param[in] index Index for device generating single click. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendSingleClick(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Double click
 * 
 * @param[in] index Index for device generating double click. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendDoubleClick(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Date
 * 
 * @param[in] index Index for device generating date. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] yearCentury Year century.
 * @param[in] year Year.
 * @param[in] month Month (1-12).
 * @param[in] day Day.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendDate(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t yearCentury, uint8_t year, uint8_t month, uint8_t day);

/**
 * Time
 * 
 * @param[in] index Index for device generating time. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] hour Hour (0-23).
 * @param[in] minutes Minutes (0-59).
 * @param[in] seconds Seconds (0-59).
 * @param[in] milliseconds Milliseconds (0-999).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendTime(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t hour, uint8_t minutes, uint8_t seconds, uint16_t milliseconds);

/**
 * Weekday
 * 
 * @param[in] index Index for device generating weekday info. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] weekday Weekday ( 0 (Monday) - 6 (Sunday)).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendWeekday(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t weekday);

/**
 * Lock
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendLock(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Unlock
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendUnlock(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * DateTime
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * @param[in] dateTime Date/time in five byte bit array. (array[5])
 * @param[in] dateTimesize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendDatetime(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const dateTime, uint8_t dateTimeSize);

/**
 * Rising
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendRising(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Falling
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendFalling(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Updated
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendUpdated(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Connect
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendConnect(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Disconnect
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendDisconnect(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Reconnect
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendReconnect(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Enter
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendEnter(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Exit
 * 
 * @param[in] index Index for device. Set to zero if not used.
 * @param[in] zone Zone for which event applies to (0-254). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-254). 255 is all sub-zones.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendExit(uint8_t index, uint8_t zone, uint8_t subZone);

/**
 * Incremented
 * 
 * @param[in] userSpecific Optional byte that have a meaning given by the issuer of the event.
 * Prefered use is _index_ for compability.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones
 * @param[in] subzone Sub-zone for which event applies to (0-255). 255 is all sub-zones
 * @param[in] incrementedValue Incremented value. The range can be adjusted by the user by sending
 * just the needed number of bytes 1-5 (optional) (array[5])
 * @param[in] incrementedValuesize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendIncremented(uint8_t userSpecific, uint8_t zone, uint8_t subzone, uint8_t const * const incrementedValue, uint8_t incrementedValueSize);

/**
 * Decremented
 * 
 * @param[in] userSpecific Optional byte that have a meaning given by the issuer of the event.
 * Prefered use is _index_ for compability.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones
 * @param[in] subzone Sub-zone for which event applies to (0-255). 255 is all sub-zones
 * @param[in] decrementedValue Decremented value. The range can be adjusted by the user by sending
 * just the needed number of bytes 1-5 (optional) (array[5])
 * @param[in] decrementedValuesize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendDecremented(uint8_t userSpecific, uint8_t zone, uint8_t subzone, uint8_t const * const decrementedValue, uint8_t decrementedValueSize);

/**
 * Proximity detected
 * 
 * @param[in] userSpecific Optional byte that have a meaning given by the issuer of the event.
 * Prefered use is _index_ for compability.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones
 * @param[in] subzone Sub-zone for which event applies to (0-255). 255 is all sub-zones
 * @param[in] proximityLevel Optional uint16 that sets proximity level if present. (optional)
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_information_sendProximityDetected(uint8_t userSpecific, uint8_t zone, uint8_t subzone, uint16_t const * const proximityLevel);

#ifdef __cplusplus
}
#endif

#endif  /* __VSCP_EVT_INFORMATION_H__ */
