/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Set value with zone
@file   vscp_evt_setvaluezone.h
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
This class mirrors the standard measurement events is CLASS1.MEASUREMENT=10 but also have zone
information and is intended for setting a value instead of providing a measurement.

This file is automatically generated. Don't change it manually.

*******************************************************************************/

#ifndef __VSCP_EVT_SETVALUEZONE_H__
#define __VSCP_EVT_SETVALUEZONE_H__

/*******************************************************************************
    INCLUDES
*******************************************************************************/
#include <stdint.h>
#include "../user/vscp_platform.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

/**
 * General event
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendGeneralEvent(void);

/**
 * Count
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendCount(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Length/Distance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendLengthDistance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Mass
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendMass(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Time
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendTime(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Electric Current
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricCurrent(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Temperature
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendTemperature(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Amount of substance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendAmountOfSubstance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Luminous Intensity (Intensity of light)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendLuminousIntensityIntensityOfLight(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Frequency
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendFrequency(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Radioactivity and other random events
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRadioactivityAndOtherRandomEvents(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Force
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendForce(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Pressure
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendPressure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Energy
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendEnergy(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Power
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendPower(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Electrical Charge
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricalCharge(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Electrical Potential (Voltage)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricalPotentialVoltage(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Electrical Capacitance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricalCapacitance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Electrical Resistance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricalResistance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Electrical Conductance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricalConductance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Magnetic Field Strength
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendMagneticFieldStrength(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Magnetic Flux
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendMagneticFlux(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Magnetic Flux Density
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendMagneticFluxDensity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Inductance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendInductance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Luminous Flux
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendLuminousFlux(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Illuminance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendIlluminance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Radiation dose
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRadiationDose(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Catalytic activity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendCatalyticActivity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Volume
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendVolume(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Sound intensity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundIntensity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Angle
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendAngle(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Position WGS 84
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendPositionWgs84(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Speed
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSpeed(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Acceleration
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendAcceleration(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Tension
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendTension(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Damp/moist (Hygrometer reading)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendDampMoistHygrometerReading(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Flow
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendFlow(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Thermal resistance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendThermalResistance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Refractive (optical) power
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRefractiveOpticalPower(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Dynamic viscosity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendDynamicViscosity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Sound impedance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundImpedance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Sound resistance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundResistance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Electric elastance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendElectricElastance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Luminous energy
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendLuminousEnergy(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Luminance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendLuminance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Chemical (molar) concentration
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendChemicalMolarConcentration(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/* "Chemical (mass) concentration" not supported. No frame defined. */

/**
 * Reserved
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendReserved(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/* "Reserved" not supported. No frame defined. */

/**
 * Dew Point
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendDewPoint(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Relative Level
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRelativeLevel(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Altitude
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendAltitude(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Area
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendArea(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Radiant intensity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRadiantIntensity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Radiance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendRadiance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Irradiance, Exitance, Radiosity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendIrradianceExitanceRadiosity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Spectral radiance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSpectralRadiance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Spectral irradiance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSpectralIrradiance(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Sound pressure (acoustic pressure)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundPressureAcousticPressure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Sound energy density
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundEnergyDensity(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

/**
 * Sound level
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] dataCoding Data coding.
 * @param[in] data Data with format defined by byte 0.  (array[4])
 * @param[in] datasize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_setvaluezone_sendSoundLevel(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t dataCoding, uint8_t const * const data, uint8_t dataSize);

#ifdef __cplusplus
}
#endif

#endif  /* __VSCP_EVT_SETVALUEZONE_H__ */
