/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Measurement with zone
@file   vscp_evt_measurezone.c
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
@see vscp_evt_measurezone.h

This file is automatically generated. Don't change it manually.

*******************************************************************************/

/*******************************************************************************
    INCLUDES
*******************************************************************************/
#include "vscp_evt_measurezone.h"
#include "../core/vscp_core.h"
#include "../core/vscp_class_l1.h"
#include "../core/vscp_type_measurezone.h"
#include "../core/vscp_data_coding.h"

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

/**
 * General event
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendGeneralEvent(void)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_GENERAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 0;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Count
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendCount(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_COUNT, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Length/Distance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendLengthDistance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_LENGTH, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Mass
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendMass(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_MASS, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Time
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendTime(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_TIME, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electric Current
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendElectricCurrent(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ELECTRIC_CURRENT, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Temperature
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendTemperature(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_TEMPERATURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Amount of substance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendAmountOfSubstance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_AMOUNT_OF_SUBSTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous Intensity (Intensity of light)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendLuminousIntensityIntensityOfLight(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_INTENSITY_OF_LIGHT, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Frequency
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendFrequency(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_FREQUENCY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radioactivity and other random events
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendRadioactivityAndOtherRandomEvents(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_RADIOACTIVITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Force
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendForce(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_FORCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Pressure
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendPressure(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_PRESSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Energy
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendEnergy(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Power
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendPower(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Charge
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendElectricalCharge(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ELECTRICAL_CHARGE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Potential (Voltage)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendElectricalPotentialVoltage(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ELECTRICAL_POTENTIAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Capacitance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendElectricalCapacitance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ELECTRICAL_CAPACITANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Resistance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendElectricalResistance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ELECTRICAL_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Conductance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendElectricalConductance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ELECTRICAL_CONDUCTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Field Strength
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendMagneticFieldStrength(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_MAGNETIC_FIELD_STRENGTH, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Flux
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendMagneticFlux(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_MAGNETIC_FLUX, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Flux Density
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendMagneticFluxDensity(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_MAGNETIC_FLUX_DENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Inductance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendInductance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_INDUCTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous Flux
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendLuminousFlux(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_FLUX_OF_LIGHT, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Illuminance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendIlluminance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ILLUMINANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiation dose (absorbed)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendRadiationDoseAbsorbed(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_RADIATION_DOSE_ABSORBED, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Catalytic activity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendCatalyticActivity(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_CATALYTIC_ACITIVITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Volume
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendVolume(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_VOLUME, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound intensity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendSoundIntensity(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_SOUND_INTENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Angle
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendAngle(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ANGLE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Position WGS 84
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendPositionWgs84(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_POSITION, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Speed
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendSpeed(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_SPEED, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Acceleration
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendAcceleration(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ACCELERATION, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Tension
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendTension(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_TENSION, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Damp/moist (Hygrometer reading)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendDampMoistHygrometerReading(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_HUMIDITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Flow
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendFlow(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_FLOW, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Thermal resistance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendThermalResistance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_THERMAL_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Refractive (optical) power
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendRefractiveOpticalPower(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_REFRACTIVE_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Dynamic viscosity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendDynamicViscosity(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_DYNAMIC_VISCOSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound impedance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendSoundImpedance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_SOUND_IMPEDANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound resistance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendSoundResistance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_SOUND_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electric elastance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendElectricElastance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ELECTRIC_ELASTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous energy
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendLuminousEnergy(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_LUMINOUS_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendLuminance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_LUMINANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Chemical (molar) concentration
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendChemicalMolarConcentration(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_CHEMICAL_CONCENTRATION_MOLAR, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/* "Chemical (mass) concentration" not supported. No frame defined. */

/**
 * Reserved
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendReserved(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_RESERVED47, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/* "Reserved" not supported. No frame defined. */

/**
 * Dew Point
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendDewPoint(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_DEWPOINT, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Relative Level
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendRelativeLevel(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_RELATIVE_LEVEL, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Altitude
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendAltitude(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_ALTITUDE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Area
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendArea(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_AREA, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiant intensity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendRadiantIntensity(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_RADIANT_INTENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendRadiance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_RADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Irradiance, Exitance, Radiosity
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendIrradianceExitanceRadiosity(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_IRRADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Spectral radiance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendSpectralRadiance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_SPECTRAL_RADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Spectral irradiance
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendSpectralIrradiance(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_SPECTRAL_IRRADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound pressure (acoustic pressure)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendSoundPressureAcousticPressure(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_SOUND_PRESSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound energy density
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendSoundEnergyDensity(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_SOUND_DENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound level
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendSoundLevel(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_SOUND_LEVEL, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiation dose (equivalent)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendRadiationDoseEquivalent(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_DOSE_EQUIVALENT, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiation dose (exposure)
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendRadiationDoseExposure(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_RADIATION_DOSE_EXPOSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Power factor
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendPowerFactor(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_POWER_FACTOR, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Reactive Power
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendReactivePower(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_REACTIVE_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Reactive Energy
 * 
 * @param[in] index Index for sensor.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] data The data as signed integer.
 * @param[in] exp The exponent of the data (10^exponent).
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurezone_sendReactiveEnergy(uint8_t index, uint8_t zone, uint8_t subZone, int32_t data, int8_t exp)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREZONE, VSCP_TYPE_MEASUREZONE_REACTIVE_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 3;
    txMsg.data[0] = index;
    txMsg.data[1] = zone;
    txMsg.data[2] = subZone;

    txMsg.dataSize += vscp_data_coding_int32ToNormalizedInteger(data, exp, &txMsg.data[3], VSCP_L1_DATA_SIZE - txMsg.dataSize);

    return vscp_core_sendEvent(&txMsg);
}

