/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Double precision floating point measurement
@file   vscp_evt_measurement64.c
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
@see vscp_evt_measurement64.h

This file is automatically generated. Don't change it manually.

*******************************************************************************/

/*******************************************************************************
    INCLUDES
*******************************************************************************/
#include "vscp_evt_measurement64.h"
#include "../core/vscp_core.h"
#include "../core/vscp_class_l1.h"
#include "../core/vscp_type_measurement64.h"

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

/**
 * General event
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendGeneralEvent(void)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_GENERAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 0;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Count
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendCount(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_COUNT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Length/Distance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendLengthDistance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_LENGTH, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Mass
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendMass(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_MASS, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Time
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendTime(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_TIME, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electric Current
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendElectricCurrent(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ELECTRIC_CURRENT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Temperature
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendTemperature(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_TEMPERATURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Amount of substance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendAmountOfSubstance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_AMOUNT_OF_SUBSTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous Intensity (Intensity of light)
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendLuminousIntensityIntensityOfLight(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_INTENSITY_OF_LIGHT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Frequency
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendFrequency(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_FREQUENCY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radioactivity and other random events
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendRadioactivityAndOtherRandomEvents(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_RADIOACTIVITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Force
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendForce(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_FORCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Pressure
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendPressure(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_PRESSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Energy
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendEnergy(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Power
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendPower(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Charge
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendElectricalCharge(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ELECTRICAL_CHARGE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Potential (Voltage)
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendElectricalPotentialVoltage(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ELECTRICAL_POTENTIAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Capacitance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendElectricalCapacitance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ELECTRICAL_CAPACITANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Resistance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendElectricalResistance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ELECTRICAL_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electrical Conductance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendElectricalConductance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ELECTRICAL_CONDUCTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Field Strength
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendMagneticFieldStrength(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_MAGNETIC_FIELD_STRENGTH, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Flux
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendMagneticFlux(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_MAGNETIC_FLUX, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Magnetic Flux Density
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendMagneticFluxDensity(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_MAGNETIC_FLUX_DENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Inductance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendInductance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_INDUCTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous Flux
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendLuminousFlux(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_FLUX_OF_LIGHT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Illuminance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendIlluminance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ILLUMINANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiation dose (absorbed)
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendRadiationDoseAbsorbed(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_RADIATION_DOSE_ABSORBED, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Catalytic activity
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendCatalyticActivity(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_CATALYTIC_ACITIVITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Volume
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendVolume(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_VOLUME, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound intensity
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendSoundIntensity(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_SOUND_INTENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Angle
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendAngle(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ANGLE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Position WGS 84
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendPositionWgs84(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_POSITION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Speed
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendSpeed(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_SPEED, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Acceleration
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendAcceleration(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ACCELERATION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Tension
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendTension(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_TENSION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Damp/moist (Hygrometer reading)
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendDampMoistHygrometerReading(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_HUMIDITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Flow
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendFlow(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_FLOW, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Thermal resistance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendThermalResistance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_THERMAL_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Refractive (optical) power
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendRefractiveOpticalPower(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_REFRACTIVE_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Dynamic viscosity
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendDynamicViscosity(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_DYNAMIC_VISCOSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound impedance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendSoundImpedance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_SOUND_IMPEDANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound resistance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendSoundResistance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_SOUND_RESISTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Electric elastance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendElectricElastance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ELECTRIC_ELASTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminous energy
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendLuminousEnergy(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_LUMINOUS_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Luminance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendLuminance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_LUMINANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Chemical (molar) concentration
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendChemicalMolarConcentration(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_CHEMICAL_CONCENTRATION_MOLAR, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/* "Chemical (mass) concentration" not supported. No frame defined. */

/**
 * Reserved
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendReserved(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_RESERVED47, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/* "Reserved" not supported. No frame defined. */

/**
 * Dew Point
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendDewPoint(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_DEWPOINT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Relative Level
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendRelativeLevel(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_RELATIVE_LEVEL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Altitude
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendAltitude(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_ALTITUDE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Area
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendArea(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_AREA, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiant intensity
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendRadiantIntensity(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_RADIANT_INTENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendRadiance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_RADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Irradiance, Exitance, Radiosity
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendIrradianceExitanceRadiosity(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_IRRADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Spectral radiance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendSpectralRadiance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_SPECTRAL_RADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Spectral irradiance
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendSpectralIrradiance(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_SPECTRAL_IRRADIANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound pressure (acoustic pressure)
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendSoundPressureAcousticPressure(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_SOUND_PRESSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound energy density
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendSoundEnergyDensity(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_SOUND_DENSITY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sound level
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendSoundLevel(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_SOUND_LEVEL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiation dose (equivalent)
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendRadiationDoseEquivalent(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_DOSE_EQUIVALENT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Radiation dose (exposure)
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendRadiationDoseExposure(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_RADIATION_DOSE_EXPOSURE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Power factor
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendPowerFactor(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_POWER_FACTOR, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Reactive Power
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendReactivePower(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_REACTIVE_POWER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Reactive Energy
 * 
 * @param[in] value The value is a "double" - IEEE-754, 64 Bits, double precision.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_measurement64_sendReactiveEnergy(double_t value)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_MEASUREMENT64, VSCP_TYPE_MEASUREMENT64_REACTIVE_ENERGY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = ((uint8_t*)&value)[7];
    txMsg.data[1] = ((uint8_t*)&value)[6];
    txMsg.data[2] = ((uint8_t*)&value)[5];
    txMsg.data[3] = ((uint8_t*)&value)[4];
    txMsg.data[4] = ((uint8_t*)&value)[3];
    txMsg.data[5] = ((uint8_t*)&value)[2];
    txMsg.data[6] = ((uint8_t*)&value)[1];
    txMsg.data[7] = ((uint8_t*)&value)[0];
    size += 8;

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

