/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Error
@file   vscp_evt_error.c
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
@see vscp_evt_error.h

This file is automatically generated. Don't change it manually.

*******************************************************************************/

/*******************************************************************************
    INCLUDES
*******************************************************************************/
#include "vscp_evt_error.h"
#include "../core/vscp_core.h"
#include "../core/vscp_class_l1.h"
#include "../core/vscp_type_error.h"

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

/**
 * Success
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendSuccess(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_SUCCESS, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_ERROR, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Channel error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendChannelError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_CHANNEL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Fifo empty error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendFifoEmptyError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_FIFO_EMPTY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Fifo full error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendFifoFullError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_FIFO_FULL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Fifo size error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendFifoSizeError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_FIFO_SIZE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Fifo wait error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendFifoWaitError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_FIFO_WAIT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Generic error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendGenericError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_GENERIC, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Hardware error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendHardwareError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_HARDWARE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * initialization error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendInitializationError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_INIT_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Missing initialization error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendMissingInitializationError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_INIT_MISSING, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Initialization ready
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendInitializationReady(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_INIT_READY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Not supported
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendNotSupported(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_NOT_SUPPORTED, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Overrun error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendOverrunError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_OVERRUN, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Receiver empty error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendReceiverEmptyError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_RCV_EMPTY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Register error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendRegisterError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_REGISTER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Transmitter full error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendTransmitterFullError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_TRM_FULL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Library error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendLibraryError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_LIBRARY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Procedural address error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendProceduralAddressError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_PROCADDRESS, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Only one instance error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendOnlyOneInstanceError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_ONLY_ONE_INSTANCE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sub driver error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendSubDriverError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_SUB_DRIVER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Timeout error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendTimeoutError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_TIMEOUT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Not open error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendNotOpenError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_NOT_OPEN, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Parameter error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendParameterError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_PARAMETER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Memory error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendMemoryError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_MEMORY, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Internal error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendInternalError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_INTERNAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Communication error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendCommunicationError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_COMMUNICATION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * User error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendUserError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_USER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Password error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendPasswordError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_PASSWORD, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Connection error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendConnectionError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_CONNECTION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Invalid handle error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendInvalidHandleError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_INVALID_HANDLE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Operation failed error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendOperationFailedError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_OPERATION_FAILED, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Supplied buffer is to small to fit content
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendSuppliedBufferIsToSmallToFitContent(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_BUFFER_SMALL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Requested item is unknown
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendRequestedItemIsUnknown(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_ITEM_UNKNOWN, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Name is already in use
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendNameIsAlreadyInUse(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_NAME_USED, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Error when writing data
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendErrorWhenWritingData(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_DATA_WRITE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Operation stopped or aborted
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendOperationStoppedOrAborted(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_ABORTED, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Pointer with invalid value
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_error_sendPointerWithInvalidValue(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_ERROR, VSCP_TYPE_ERROR_INVALID_POINTER, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

