/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Diagnostic
@file   vscp_evt_diagnostic.h
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
Diagnostic functionality.

This file is automatically generated. Don't change it manually.

*******************************************************************************/

#ifndef __VSCP_EVT_DIAGNOSTIC_H__
#define __VSCP_EVT_DIAGNOSTIC_H__

/*******************************************************************************
    INCLUDES
*******************************************************************************/
#include <stdint.h>
#include "../user/vscp_platform.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

/**
 * General event
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendGeneralEvent(void);

/**
 * Overvoltage
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendOvervoltage(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Undervoltage
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendUndervoltage(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * USB VBUS low
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendUsbVbusLow(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Battery voltage low
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBatteryVoltageLow(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Battery full voltage
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBatteryFullVoltage(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Battery error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBatteryError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Battery OK
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBatteryOk(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Over current
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendOverCurrent(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Circuit error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendCircuitError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Short circuit
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendShortCircuit(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Open Circuit
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendOpenCircuit(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Moist
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendMoist(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Wire failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendWireFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Wireless faliure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendWirelessFaliure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * IR failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendIrFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * 1-wire failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_send1WireFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * RS-222 failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRs222Failure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * RS-232 failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRs232Failure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * RS-423 failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRs423Failure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * RS-485 failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRs485Failure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * CAN failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendCanFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * LAN failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendLanFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * USB failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendUsbFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Wifi failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendWifiFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * NFC/RFID failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendNfcRfidFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Low signal
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendLowSignal(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * High signal
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendHighSignal(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * ADC failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendAdcFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * ALU failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendAluFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Assert
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendAssert(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * DAC failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendDacFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * DMA failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendDmaFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Ethernet failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendEthernetFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Exception
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendException(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * FPU failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendFpuFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * GPIO failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendGpioFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * I2C failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendI2cFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * I2S failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendI2sFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Invalid configuration
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendInvalidConfiguration(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * MMU failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendMmuFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * NMI failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendNmiFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Overheat
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendOverheat(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * PLL fail
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendPllFail(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * POR failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendPorFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * PWM failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendPwmFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * RAM failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRamFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * ROM failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRomFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * SPI failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSpiFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Stack failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendStackFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * LIN bus failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendLinBusFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * UART failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendUartFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Unhandled interrupt
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendUnhandledInterrupt(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Memory failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendMemoryFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Variable range failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendVariableRangeFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * WDT failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendWdtFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * EEPROM failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendEepromFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Encryption failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendEncryptionFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Bad user input failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBadUserInputFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Decryption failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendDecryptionFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Noise
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendNoise(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Boot loader failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBootLoaderFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Program flow failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendProgramFlowFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * RTC faiure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRtcFaiure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * System test failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSystemTestFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Sensor failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSensorFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Safe state entered
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSafeStateEntered(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Signal implausible
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSignalImplausible(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Storage fail
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendStorageFail(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Self test OK
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSelfTestOk(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * ESD/EMC/EMI failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendEsdEmcEmiFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Timeout
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendTimeout(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * LCD failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendLcdFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Touch panel failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendTouchPanelFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * No load
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendNoLoad(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Cooling failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendCoolingFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Heating failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendHeatingFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Transmission failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendTransmissionFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Receiption failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendReceiptionFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * External IC failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendExternalIcFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Charging on
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendChargingOn(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

/**
 * Charging off
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendChargingOff(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize);

#ifdef __cplusplus
}
#endif

#endif  /* __VSCP_EVT_DIAGNOSTIC_H__ */
