/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Diagnostic
@file   vscp_evt_diagnostic.c
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
@see vscp_evt_diagnostic.h

This file is automatically generated. Don't change it manually.

*******************************************************************************/

/*******************************************************************************
    INCLUDES
*******************************************************************************/
#include "vscp_evt_diagnostic.h"
#include "../core/vscp_core.h"
#include "../core/vscp_class_l1.h"
#include "../core/vscp_type_diagnostic.h"

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

/**
 * General event
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendGeneralEvent(void)
{
    vscp_TxMessage  txMsg;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_GENERAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.dataSize = 0;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Overvoltage
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendOvervoltage(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_OVERVOLTAGE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Undervoltage
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendUndervoltage(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_UNDERVOLTAGE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * USB VBUS low
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendUsbVbusLow(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_VBUS_LOW, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Battery voltage low
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBatteryVoltageLow(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_BATTERY_LOW, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Battery full voltage
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBatteryFullVoltage(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_BATTERY_FULL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Battery error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBatteryError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_BATTERY_ERROR, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Battery OK
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBatteryOk(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_BATTERY_OK, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Over current
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendOverCurrent(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_OVERCURRENT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Circuit error
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendCircuitError(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_CIRCUIT_ERROR, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Short circuit
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendShortCircuit(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_SHORT_CIRCUIT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Open Circuit
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendOpenCircuit(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_OPEN_CIRCUIT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Moist
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendMoist(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_MOIST, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Wire failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendWireFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_WIRE_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Wireless faliure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendWirelessFaliure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_WIRELESS_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * IR failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendIrFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_IR_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * 1-wire failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_send1WireFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_1WIRE_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * RS-222 failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRs222Failure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_RS222_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * RS-232 failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRs232Failure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_RS232_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * RS-423 failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRs423Failure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_RS423_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * RS-485 failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRs485Failure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_RS485_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * CAN failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendCanFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_CAN_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * LAN failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendLanFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_LAN_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * USB failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendUsbFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_USB_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Wifi failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendWifiFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_WIFI_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * NFC/RFID failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendNfcRfidFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_NFC_RFID_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Low signal
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendLowSignal(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_LOW_SIGNAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * High signal
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendHighSignal(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_HIGH_SIGNAL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * ADC failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendAdcFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_ADC_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * ALU failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendAluFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_ALU_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Assert
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendAssert(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_ASSERT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * DAC failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendDacFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_DAC_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * DMA failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendDmaFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_DMA_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Ethernet failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendEthernetFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_ETH_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Exception
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendException(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_EXCEPTION, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * FPU failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendFpuFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_FPU_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * GPIO failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendGpioFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_GPIO_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * I2C failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendI2cFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_I2C_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * I2S failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendI2sFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_I2S_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Invalid configuration
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendInvalidConfiguration(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_INVALID_CONFIG, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * MMU failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendMmuFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_MMU_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * NMI failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendNmiFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_NMI, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Overheat
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendOverheat(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_OVERHEAT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * PLL fail
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendPllFail(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_PLL_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * POR failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendPorFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_POR_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * PWM failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendPwmFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_PWM_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * RAM failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRamFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_RAM_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * ROM failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRomFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_ROM_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * SPI failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSpiFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_SPI_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Stack failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendStackFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_STACK_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * LIN bus failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendLinBusFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_LIN_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * UART failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendUartFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_UART_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Unhandled interrupt
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendUnhandledInterrupt(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_UNHANDLED_INT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Memory failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendMemoryFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_MEMORY_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Variable range failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendVariableRangeFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_VARIABLE_RANGE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * WDT failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendWdtFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_WDT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * EEPROM failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendEepromFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_EEPROM_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Encryption failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendEncryptionFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_ENCRYPTION_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Bad user input failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBadUserInputFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_BAD_USER_INPUT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Decryption failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendDecryptionFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_DECRYPTION_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Noise
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendNoise(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_NOISE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Boot loader failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendBootLoaderFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_BOOTLOADER_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Program flow failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendProgramFlowFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_PROGRAMFLOW_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * RTC faiure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendRtcFaiure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_RTC_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * System test failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSystemTestFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_SYSTEM_TEST_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Sensor failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSensorFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_SENSOR_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Safe state entered
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSafeStateEntered(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_SAFESTATE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Signal implausible
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSignalImplausible(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_SIGNAL_IMPLAUSIBLE, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Storage fail
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendStorageFail(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_STORAGE_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Self test OK
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendSelfTestOk(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_SELFTEST_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * ESD/EMC/EMI failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendEsdEmcEmiFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_ESD_EMC_EMI, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Timeout
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendTimeout(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_TIMEOUT, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * LCD failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendLcdFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_LCD_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Touch panel failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendTouchPanelFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_TOUCHPANEL_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * No load
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendNoLoad(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_NOLOAD, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Cooling failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendCoolingFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_COOLING_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Heating failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendHeatingFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_HEATING_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Transmission failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendTransmissionFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_TX_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Receiption failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendReceiptionFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_RX_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * External IC failure
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendExternalIcFailure(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_EXT_IC_FAIL, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Charging on
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendChargingOn(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_CHARGING_ON, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

/**
 * Charging off
 * 
 * @param[in] index Index. Often used as an index for channels/subdevices within a module.
 * @param[in] zone Zone for which event applies to (0-255). 255 is all zones.
 * @param[in] subZone Sub-zone for which event applies to (0-255). 255 is all sub-zones.
 * @param[in] user Can be present or not be present. If present the bytes give additional user
 * specific information. (optional) (array[5])
 * @param[in] usersize Size in byte.
 * 
 * @return If event is sent, it will return TRUE otherwise FALSE.
 */
extern BOOL vscp_evt_diagnostic_sendChargingOff(uint8_t index, uint8_t zone, uint8_t subZone, uint8_t const * const user, uint8_t userSize)
{
    vscp_TxMessage  txMsg;
    uint8_t         size    = 0;
    uint8_t         byteIndex   = 0;

    vscp_core_prepareTxMessage(&txMsg, VSCP_CLASS_L1_DIAGNOSTIC, VSCP_TYPE_DIAGNOSTIC_CHARGING_OFF, VSCP_PRIORITY_3_NORMAL);

    txMsg.data[0] = index;
    size += 1;

    txMsg.data[1] = zone;
    size += 1;

    txMsg.data[2] = subZone;
    size += 1;

    if (NULL != user)
    {
        for(byteIndex = 0; byteIndex < userSize; ++byteIndex)
        {
            txMsg.data[3 + byteIndex] = user[byteIndex];
            size += 1;

            if (VSCP_L1_DATA_SIZE <= size)
            {
                break;
            }
        }
    }

    txMsg.dataSize = size;

    return vscp_core_sendEvent(&txMsg);
}

