/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Phone
@file   vscp_type_phone.h
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
This class is for phone related functionality.

This file is automatically generated. Don't change it manually.

*******************************************************************************/

#ifndef __VSCP_TYPE_PHONE_H__
#define __VSCP_TYPE_PHONE_H__

/** @defgroup vscp_type_phone Phone
 * Level 1 protocol class types
 * @{
 * @ingroup vscp_l1
 */

/*******************************************************************************
    INCLUDES
*******************************************************************************/

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/**
 * General Event.
 */
#define VSCP_TYPE_PHONE_GENERAL       0

/**
 * There is an incoming phone call. Usually a caller ID node just sends out numerical information. A
 * database event can follow (later) that contains the real text information.
 * Phone calls are reported in the following form
 * from,to
 * where from is the originating number and to is the receiving phone. Numbers is preferable presented
 * in an international form. So a call from England to a Swedish phone should take the following form
 * 44-123-1122334,46-657-413430
 * which is sent in tree frames. Some device can't separate country and area-code and therefore the
 * form
 * 441231122334,46657413430
 * will also be valid.
 * a database connected application can later resolve this and present
 * A customer,Eurosource
 * This is the type=8 event, database info, (see below). Note that the comma cant be used in the
 * descriptive names.
 * Calls from unlisted numbers are presented as
 * ,to
 */
#define VSCP_TYPE_PHONE_INCOMING_CALL 1

/**
 * There is an outgoing phone call.
 */
#define VSCP_TYPE_PHONE_OUTGOING_CALL 2

/**
 * This is a event indicating that there is a “ring” for this call.
 */
#define VSCP_TYPE_PHONE_RING          3

/**
 * The call has been answered.
 */
#define VSCP_TYPE_PHONE_ANSWER        4

/**
 * The call has been terminated by the receiving end.
 */
#define VSCP_TYPE_PHONE_HANGUP        5

/**
 * The call has been terminated by the originating end. byte
 */
#define VSCP_TYPE_PHONE_GIVEUP        6

/**
 * The call has been transferred. byte
 */
#define VSCP_TYPE_PHONE_TRANSFER      7

/**
 * Call database info.
 */
#define VSCP_TYPE_PHONE_DATABASE_INFO 8

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* __VSCP_TYPE_PHONE_H__ */

/** @} */
