/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Display
@file   vscp_type_display.h
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
This is generic display related functionality. Show info on a screen, LED-display diode, etc.

This file is automatically generated. Don't change it manually.

*******************************************************************************/

#ifndef __VSCP_TYPE_DISPLAY_H__
#define __VSCP_TYPE_DISPLAY_H__

/** @defgroup vscp_type_display Display
 * Level 1 protocol class types
 * @{
 * @ingroup vscp_l1
 */

/*******************************************************************************
    INCLUDES
*******************************************************************************/

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/**
 * General Event.
 */
#define VSCP_TYPE_DISPLAY_GENERAL                  0

/**
 * Clear the display on displays in a certain zone,sub-zone.
 */
#define VSCP_TYPE_DISPLAY_CLEAR_DISPLAY            1

/**
 * Move the cursor to a specific position on displays in a certain zone,sub-zone.
 */
#define VSCP_TYPE_DISPLAY_POSITION_CURSOR          2

/**
 * Write to display(s) in a certain zone,sub-zone. The update of the display is immediate.
 */
#define VSCP_TYPE_DISPLAY_WRITE_DISPLAY            3

/**
 * Write to the buffers of displays in a certain zone,sub-zone. The update of the display is is not
 * done right away but is instead done when the Show Buffer event is received by the display unit.
 */
#define VSCP_TYPE_DISPLAY_WRITE_DISPLAY_BUFFER     4

/**
 * Tells displays in a certain zone,sub-zone to display the content in their display buffers. The
 * update of the display is immediate.
 */
#define VSCP_TYPE_DISPLAY_SHOW_DISPLAY_BUFFER      5

/**
 * With this call a display buffer parameter can be sent to a display. This parameter is inserted at
 * the escape position %pn in the string in the buffer when the buffer is transferred to the display.
 * Note that there are no zone and sub-zone defined for this event and the escapes must instead be
 * chosen to be distinct in a system. This means that &p1 will be unique within a system and updating
 * this parameter will update on all displays that has it defined.
 */
#define VSCP_TYPE_DISPLAY_SET_DISPLAY_BUFFER_PARAM 6

/**
 * This event contains information that should be displayed on displays pointed out by zone/sub-zone.
 * This event can have the same functionality as Write Display or be set on an higher abstraction
 * level.
 */
#define VSCP_TYPE_DISPLAY_SHOW_TEXT                32

/**
 * This event contains information that should be displayed on LED(s) pointed out by zone/sub-zone.
 */
#define VSCP_TYPE_DISPLAY_SET_LED                  48

/**
 * This event set the color for LED(s) (or similar device) pointed out by zone/sub-zone.
 */
#define VSCP_TYPE_DISPLAY_SET_COLOR                49

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* __VSCP_TYPE_DISPLAY_H__ */

/** @} */
