/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Data
@file   vscp_type_data.h
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
Representation for different general data types. Byte 0 is the data coding byte described here.
Unit may not have meaning for some of the types and should be set to zero in that case.

This file is automatically generated. Don't change it manually.

*******************************************************************************/

#ifndef __VSCP_TYPE_DATA_H__
#define __VSCP_TYPE_DATA_H__

/** @defgroup vscp_type_data Data
 * Level 1 protocol class types
 * @{
 * @ingroup vscp_l1
 */

/*******************************************************************************
    INCLUDES
*******************************************************************************/

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/**
 * General event.
 */
#define VSCP_TYPE_DATA_GENERAL           0

/**
 * General I/O value. First data byte defines format.
 */
#define VSCP_TYPE_DATA_IO                1

/**
 * General A/D value. First data byte defines format.
 */
#define VSCP_TYPE_DATA_AD                2

/**
 * General D/A value. First data byte defines format.
 */
#define VSCP_TYPE_DATA_DA                3

/**
 * Relative strength.
 */
#define VSCP_TYPE_DATA_RELATIVE_STRENGTH 4

/**
 * Signal Level is a relative strength value that (as default) has its maximum at 100 and minimum at 0
 * interpreted as a percentage. For a digital transmission Signal Level it can be used to give an
 * indication of the analogue signal and CLASS1.DATA, Type = 6, Signal Quality can be used to give an
 * indication of the quality of the digital part as BER (Bit Error Ratio) for example.
 */
#define VSCP_TYPE_DATA_SIGNAL_LEVEL      5

/**
 * Signal Quality be used to give an indication of the quality of the digital part as BER (Bit Error
 * Ratio) for example.
 */
#define VSCP_TYPE_DATA_SIGNAL_QUALITY    6

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* __VSCP_TYPE_DATA_H__ */

/** @} */
