/* The MIT License (MIT)
 *
 * Copyright (c) 2014 - 2025 Andreas Merkle
 * http://www.blue-andi.de
 * vscp@blue-andi.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*******************************************************************************
    DESCRIPTION
*******************************************************************************/
/**
@brief  Configuration
@file   vscp_type_configuration.h
@author Andreas Merkle, http://www.blue-andi.de

@section desc Description
Events for configuration of sets and parameters on nodes without register manipulation.

This file is automatically generated. Don't change it manually.

*******************************************************************************/

#ifndef __VSCP_TYPE_CONFIGURATION_H__
#define __VSCP_TYPE_CONFIGURATION_H__

/** @defgroup vscp_type_configuration Configuration
 * Level 1 protocol class types
 * @{
 * @ingroup vscp_l1
 */

/*******************************************************************************
    INCLUDES
*******************************************************************************/

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
    COMPILER SWITCHES
*******************************************************************************/

/*******************************************************************************
    CONSTANTS
*******************************************************************************/

/**
 * General Event.
 */
#define VSCP_TYPE_CONFIGURATION_GENERAL               0

/**
 * Load a specific configuration on a node.  The configuration to load is defined by a 16-byte
 * configuration id. It is recommended that configuration id zero is the default configuration.
 * The optional control byte can be used to request a reset if the device after configuration is
 * loaded.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_LOAD_ACK should be sent by the node after loading the
 * new configuration to acknowledge a successful load of configuration data.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_LOAD_NACK should be sent by the node after loading
 * the new configuration to negative acknowledge a failed load of configuration data.
 */
#define VSCP_TYPE_CONFIGURATION_LOAD                  1

/**
 * This event should be sent by the node after loading a new configuration to acknowledge a successful
 * load of configuration data. The configuration id for the successfully loaded configuration should
 * be given in byte 0 and 1.
 */
#define VSCP_TYPE_CONFIGURATION_LOAD_ACK              2

/**
 * This event should be sent by the node after loading a new configuration to negative acknowledge an
 * unsuccessful load of configuration data. The configuration id for the unsuccessfully loaded
 * configuration should be given in byte 0 and 1.
 */
#define VSCP_TYPE_CONFIGURATION_LOAD_NACK             3

/**
 * Save a specific configuration on a node.  The configuration to save is identified by a 16-byte
 * configuration id. It is recommended that configuration id zero is the default configuration.
 * The optional control byte can be used to request a reset if the device after configuration is
 * saved.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_SAVE_ACK should be sent by the node after saving the
 * new configuration to acknowledge a successful save of configuration data.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_SAVE_NACK should be sent by the node after saving the
 * new configuration to negative acknowledge a failed save of configuration data.
 */
#define VSCP_TYPE_CONFIGURATION_SAVE                  4

/**
 * This event should be sent by the node after saving a new configuration to acknowledge a successful
 * save of configuration data. The configuration id for the successfully saved configuration should be
 * given in byte 0 and 1.
 */
#define VSCP_TYPE_CONFIGURATION_SAVE_ACK              5

/**
 * This event should be sent by the node after saving a new configuration to negative acknowledge an
 * unsuccessful save of configuration data. The configuration id for the unsuccessfully saved
 * configuration should be given in byte 0 and 1.
 */
#define VSCP_TYPE_CONFIGURATION_SAVE_NACK             6

/**
 * Commit a specific configuration on a node.  The configuration to commit is identified by a 16-byte
 * configuration id. It is recommended that configuration id zero is the default configuration.
 * The optional control byte can be used to request a reset if the device after configuration is
 * saved.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_COMMIT_ACK should be sent by the node after
 * committing the new configuration to acknowledge a successful commit of configuration data.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_COMMIT_NACK should be sent by the node after
 * committing the new configuration to negative acknowledge a failed commit of configuration data.
 */
#define VSCP_TYPE_CONFIGURATION_COMMIT                7

/**
 * This event should be sent by the node after committing a new configuration to acknowledge a
 * successful commit of configuration data. The configuration id for the successfully committed
 * configuration should be given in byte 0 and 1.
 */
#define VSCP_TYPE_CONFIGURATION_COMMIT_ACK            8

/**
 * This event should be sent by the node after committing a new configuration to negative acknowledge
 * an unsuccessful commit of configuration data. The configuration id for the unsuccessfully committed
 * configuration should be given in byte 0 and 1.
 */
#define VSCP_TYPE_CONFIGURATION_COMMIT_NACK           9

/**
 * Reload a specific configuration on a node.  The configuration to reload is identified by a 16-byte
 * configuration id. It is recommended that configuration id zero is the default configuration.
 * The optional control byte can be used to request a reset if the device after configuration is
 * saved.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_RELOAD_ACK should be sent by the node after reloadinf
 * the new configuration to acknowledge a successful reload of configuration data.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_RELOAD_NACK should be sent by the node after
 * reloading the new configuration to negative acknowledge a failed reload of configuration data.
 */
#define VSCP_TYPE_CONFIGURATION_RELOAD                10

/**
 * This event should be sent by the node after reloading a new configuration to acknowledge a
 * successful reload of configuration data. The configuration id for the successfully reloaded
 * configuration should be given in byte 0 and 1.
 */
#define VSCP_TYPE_CONFIGURATION_REALOD_ACK            11

/**
 * This event should be sent by the node after reloading a new configuration to negative acknowledge
 * an unsuccessful reload of configuration data. The configuration id for the unsuccessfully reloaded
 * configuration should be given in byte 0 and 1.
 */
#define VSCP_TYPE_CONFIGURATION_RELOAD_NACK           12

/**
 * Restore a specific configuration on a node.  The configuration to restore is identified by a
 * 16-byte configuration id. It is recommended that configuration id zero is the default
 * configuration.
 * The optional control byte can be used to request a reset if the device after configuration is
 * saved.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_RESTORE_ACK should be sent by the node after
 * restoring the new configuration to acknowledge a successful restore of configuration data.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_RESTORE_NACK should be sent by the node after
 * restoring the new configuration to negative acknowledge a failed restore of configuration data.
 */
#define VSCP_TYPE_CONFIGURATION_RESTORE               13

/**
 * This event should be sent by the node after restoring a new configuration to acknowledge a
 * successful restore of configuration data. The configuration id for the successfully restored
 * configuration should be given in byte 0 and 1.
 */
#define VSCP_TYPE_CONFIGURATION_RESTORE_ACK           14

/**
 * This event should be sent by the node after restoring a new configuration to negative acknowledge
 * an unsuccessful restore of configuration data. The configuration id for the unsuccessfully restored
 * configuration should be given in byte 0 and 1.
 */
#define VSCP_TYPE_CONFIGURATION_RESTORE_NACK          15

/**
 * Set a parameter identified by a 16-bit parameter id to a value identified by a 16-bit value
 * identifier. A typical examples of the use of this event is to set the unit for a measurement on one
 * or several nodes. It is recommended that the value identifier zero is used as the default value for
 * a parameter.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_SET_MODE_ACK should be sent by the node after setting
 * the new value.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_SET_MODE_NACK should be sent by the node if it fails
 * to set the new value.
 */
#define VSCP_TYPE_CONFIGURATION_SET_PARAMETER         30

/**
 * Set the default value for a parameter identified by a 16-bit parameter id. In most cases this is
 * the same as setting the mode for a parameter to value id zero.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_SET_MODE_ACK should be sent by the node after setting
 * the new value.
 * CLASS1.CONFIGURATION, VSCP_TYPE_CONFIGURATION_SET_MODE_NACK should be sent by the node if it fails
 * to set the new value.
 */
#define VSCP_TYPE_CONFIGURATION_SET_PARAMETER_DEFAULT 31

/**
 * This event should be sent by the node after setting the new value.
 */
#define VSCP_TYPE_CONFIGURATION_SET_PARAMETER_ACK     32

/**
 * Should be sent by the node if it fails to set the new value.
 */
#define VSCP_TYPE_CONFIGURATION_SET_PARAMETER_NACK    33

/*******************************************************************************
    MACROS
*******************************************************************************/

/*******************************************************************************
    TYPES AND STRUCTURES
*******************************************************************************/

/*******************************************************************************
    VARIABLES
*******************************************************************************/

/*******************************************************************************
    FUNCTIONS
*******************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* __VSCP_TYPE_CONFIGURATION_H__ */

/** @} */
