/*************************************************
File:             BMduino_BW16.h
Author:           BEST MODULES CORP.
Description:      Define classes and required variables 
version:          V1.0.1-2025-8-22
**************************************************/
#ifndef _BMduino_BW16_H_
#define _BMduino_BW16_H_
 
#include <Arduino.h>


#define BW16_DEFAULT_BAUD 115200
#define RES_MAX_LENGTH 2000

#define AT_ACK_SUCCESS 0
#define AT_ACK_ERROR -1
#define ERROR_TIME_OUT -2
#define ERROR_SERIAL_NULL -3
#define ERROR_STORAGE -4 //Exceeding maximum storage capacity

#define MQTT_IS_DATA_READ 1
#define MQTT_NO_DATA_READ 0
//----------------------wifi status---------------------------
#define  WIFI_STATUS_GOT_IP  2
#define  WIFI_STATUS_CONNETED  3
#define  WIFI_STATUS_DISCONNETED  4
#define  WIFI_STATUS_NO_CONNET  5

#define  WIFI_URLTYPE_HTTP  1
#define  WIFI_URLTYPE_HTTPS  2
/*! Subclassing Print makes debugging easier -- output en route to BW16 module
 * can be duplicated on a second stream (e.g. Serial). !*/
class BMduino_BW16 
{
  public:
      BMduino_BW16( HardwareSerial *theSerial = &Serial);

      void begin(uint32_t baud = BW16_DEFAULT_BAUD);    

     
      int  sendATwithACK(String StringstrCmd,int timeout,String StringAck="OK");  
      String readAck();

      int reset(void); 
      
      String SSID();
      String getSSID();
      String getIP();
      String getGateway();
      String getMacAddress();
      String getATVersion();


      int connectToAP(String ssid,String password);
      int connectTCP(String ip,  int port);

      int mqtt_config(String clientid,String username,String password,String mqtt_host,int server_port);
      int mqtt_setSubscribetopic(String subscribetopic);
      int mqtt_writeString(String Dbuffer,String topic);
      int mqtt_writeBytes(char Dbuffer[],int Dlength,String topic);
      int mqtt_readSubscribeData(String *ReciveBuff,int *ReciveBufflen,String *topic);


      String http_getString(int type,String serverURL,int port,String subURL="/");



      char BW16Response[RES_MAX_LENGTH];
      int resLength = 0;   
  private:
      int testAT(void);
      void clearResponse();


      HardwareSerial *_serial = NULL;

};

enum
{
  
  RST_Fail=1,
  Init_Fail,
  Station_Fail,
  WIFI_CONNECTED_Fail,
  TCP_CONNECTED_Fail,
  TCP_Senddata_Fail,

  MQTTSNTP_FAIL= 10,
  MQTTUSERCFG_Fail,
  MQTTCLIENTID_Fail,
  MQTTUSERNAME_Fail,
  MQTTPASSWORD_Fail,
  MQTTConnect_Fail,
  MQTTTopic_Fail
};

#endif // _BMduino_BW16_H_
