  /*************************************************
  File:             BMduino_BW16.cpp
  Author:           BEST MODULES CORP.
  Description:      UART communication with the BW16 
  version:          V1.0.1-2025-6-22
  **************************************************/
  #include "BMduino_BW16.h"
   #include "myStr.h"
  /**********************************************************
  Description: Constructor
  Parameters:  *theSerial is hardware serial 
              BMduino optional:serial(default) serial1/seria2/seria3/seria4
              UNO optional:serial(default)
  Return:      none     
  Others:     
  **********************************************************/
    BMduino_BW16::BMduino_BW16(HardwareSerial *theSerial)
    {
      _serial = theSerial;//Set serial port
    }

  /**********************************************************
   Description: Module serial Initial
  Parameters:  baudRate : Set the Module  baudRate       
  Return:     void      
  Others:   If the hardware UART is initialized, the _softSerial 
            pointer is null, otherwise it is non-null       
  **********************************************************/
  void BMduino_BW16::begin(uint32_t baud)
  {
      if(_serial!=NULL)
      {    _serial->begin(baud);
      }
  }
  /**********************************************************
  Description: Send AT command and return result.
  Parameters:  StringstrCmd : Send AT command
              timeout : Receive time out  
              StringAck : If receive data，default "OK" 
   Return: result
               0(AT_ACK_SUCCESS)：AT Ack success
              -1(AT_ACK_ERROR)：AT Ack error
              -2(ERROR_TIME_OUT)：Serial timeout
              -3(A ERROR_SERIAL_NULL)：Serial error
              -4（ERROR_STORAGE）：AT Ack data exceed  maximum storage capacity
  Others:   
  **********************************************************/

  int BMduino_BW16::sendATwithACK(String StringstrCmd, int timeout,String StringAck)
  {
    char *line;
    char array[100];
    //strcpy(array, StringAck.c_str());
    StringAck.toCharArray(array, StringAck.length()+1);
    u32 sys_mills;

    u8 result=AT_ACK_SUCCESS;
    //Serial.print("start test:");
    //Serial.println(StringstrCmd); 
    if(_serial==NULL) return ERROR_SERIAL_NULL;

  for (u8 retry = 0; retry < 3; retry++)
  {
    /* code */
 
      
        while (_serial->available() > 0) {//clear UART buffer
            _serial->read();  
        }

        clearResponse();
        _serial->println(StringstrCmd); //send command
      //Serial.println(StringstrCmd);
        sys_mills= millis(); //Restore current system millis
        line=BW16Response;
        while(1)
        {
          if(_serial->available())//If data received
          {
            u8 temp;
            sys_mills=millis(); // Current system millis
            temp=_serial->read();//Read UART buffer
            BW16Response[resLength]=temp;
            //Serial.write(temp);
            if(resLength>=RES_MAX_LENGTH)
            {
              Serial.print("Exceeding maximum storage");  
              return ERROR_STORAGE;
            }

            //Serial.print(BW16Response[resLength]);
            
            if(BW16Response[resLength]==0x0A)//If new line received
            {
            
              if(strstr(line,array) != NULL)//if Received is StringAck
              { 
                result= AT_ACK_SUCCESS;
                return result;
              }         
              else
              {
                result=AT_ACK_ERROR;
              } 
              line=BW16Response+resLength+1;     
            }
            else  if(BW16Response[resLength]=='>')//if Received is ">"
            {
              result= AT_ACK_SUCCESS;
              return result;
            }
            resLength++;
          }
          else if((millis()-sys_mills)>timeout)//time out
          {
          // Serial.println("time out");
            if(result!=AT_ACK_ERROR)result= ERROR_TIME_OUT;
            break;
          }  
        }
    }
    return result;
  }
 /**********************************************************
  Description: Get AT Ack data.
  Parameters:  void
  Return:return AT Ack data.
  Others:   
  **********************************************************/
String BMduino_BW16::readAck()
{
  return String(BW16Response);
}
 /**********************************************************
  Description: test AT command.
  Parameters:  void
  Return: result
               0(AT_ACK_SUCCESS)：AT Ack success
              -1(AT_ACK_ERROR)：AT Ack error
              -2(ERROR_TIME_OUT)：Serial timeout
              -3(A ERROR_SERIAL_NULL)：：Serial error
  Others:   
  **********************************************************/
  int BMduino_BW16::testAT()
  {
    return sendATwithACK("AT",1000);
  }
  /**********************************************************
  Description: send <AT+RST> command to softreset the module
  Parameters:   void        
  Return: result
               0(AT_ACK_SUCCESS)：AT Ack success
              -1(AT_ACK_ERROR)：AT Ack error
              -2(ERROR_TIME_OUT)：Serial timeout
              -3(A ERROR_SERIAL_NULL)：：Serial error                                    
  Others:     
  **********************************************************/
  int BMduino_BW16::reset(void)
  {
    int result;
    result=sendATwithACK("AT+RST",1000);
    if(result==AT_ACK_SUCCESS)//rest
    {
      delay(3000);
      return AT_ACK_SUCCESS;
    }
    else
    {
      return result;
    } 
  }
 /**********************************************************
  Description: Get surrounding WiFi information
  Parameters:  void
  Return: return WiFi information
  Others:   
  **********************************************************/
String BMduino_BW16::SSID(){
  String result="AT error";
  int Ack=sendATwithACK("AT+WSCAN",3000);
  if(Ack==AT_ACK_SUCCESS)
  {
      result=String(BW16Response);
  }
  else if(Ack==ERROR_STORAGE){
    result=String(BW16Response)+"\r\nExceeding maximum storage";
  }
  return result;
}

/**********************************************************
Description: Get current connected SSID.
Parameters:  void   
Return:      The name of the currently connected WIFI
Others:      void
**********************************************************/
String BMduino_BW16::getSSID(){
  String result="AT error";

  if(sendATwithACK("AT+STAINFO?",1000)==AT_ACK_SUCCESS)
  {
    char *newstr;
    newstr=str_getline(BW16Response,4);

    // Serial.print("BW16Response:");
    // Serial.println(BW16Response);
    // Serial.print("newstr");
    // Serial.println(newstr);

    if(newstr!=NULL)
    {
      int endpos;
      char temp[101];
      endpos=str_linelen(newstr);
    //  Serial.print("endpos:");
    //  Serial.println(endpos);
      if(endpos>=100)endpos=100;
      memcpy(temp,newstr+5,endpos-5);
      temp[endpos-5]='\0';
      result=String(temp);
    }
  }
  return result;
}

/**********************************************************
Description: get MAC address
Parameters:  void   
Return:      MAC string
Others:        
**********************************************************/
String BMduino_BW16::getMacAddress(){
  String result="AT error";

  if(sendATwithACK("AT+STAINFO?",1000)==AT_ACK_SUCCESS)
  {
    char *newstr;
    char mac[12];
    uint8_t j=0;
    newstr=str_getline(BW16Response,6);
    if(newstr==NULL) return result;
    newstr=strtok(newstr,",");
    if(newstr==NULL) return result;

    for (uint8_t i = 0; i < 2; i++)
    { 
      newstr=strtok(NULL,",");
      if(newstr==NULL) return result;
    } 

    for (uint8_t i = 0; i < 18; i+=3)
    { 
      mac[j++]=toupper(newstr[i]);
      mac[j++]=toupper(newstr[i+1]);
    }
    result=String(mac);
  } 
  return result;  
}

/**********************************************************
Description: get AT command  version
Parameters:  void   
Return:     AT command  version
Others:        
**********************************************************/
String BMduino_BW16::getATVersion()
{
  String AckString="AT error";

  if(sendATwithACK("AT+GMR",1000)==AT_ACK_SUCCESS)
  {
      char *pos1;
      int len;
      char *newstr;
      char temp[30];

      newstr=str_getline(BW16Response,3);
      if(newstr!=nullptr)
      {
        pos1=strchr(newstr,'/');
        len=str_linelen(newstr);
        memcpy(temp,pos1+1,newstr+len-pos1); 
        AckString=String(temp);
      }
   }
  return AckString;
}
/**********************************************************
Description: Get the IP address of the currently connected AP
Parameters:  void   
Return:      IP string
Others:       Connect to AP for data, otherwise 0
**********************************************************/
/*
AT+STAINFO?

+STAINFO:3
SSID:zengdebin
Password:123456789
00:00:00:00:00:00,WPA2 AES,94:c9:60:ed:20:47,1,192.168.18.17,192.168.18.44
OK
*/
String BMduino_BW16::getIP(){
  String result="AT error";

  if(sendATwithACK("AT+STAINFO?",1000)==AT_ACK_SUCCESS)
  {
    char *newstr;
    uint8_t j=0;
    newstr=str_getline(BW16Response,6);
    if(newstr==NULL) return result;
    newstr=strtok(newstr,",");
    if(newstr==NULL) return result;

    for (uint8_t i = 0; i < 4; i++)
    { 
      newstr=strtok(NULL,",");
      if(newstr==NULL) return result;
    } 
    result=String(newstr);
  } 
  return result;  
}
/**********************************************************
Description: Get the Gateway address of the currently connected AP
Parameters:  void   
Return:      Gateway string
Others:       Connect to AP for data, otherwise 0
**********************************************************/
String BMduino_BW16::getGateway(){
  String result="AT error";

  if(sendATwithACK("AT+STAINFO?",1000)==AT_ACK_SUCCESS)
  {
    char *newstr;
    uint8_t j=0;
    newstr=str_getline(BW16Response,6);
    if(newstr==NULL) return result;
    newstr=strtok(newstr,",");
    if(newstr==NULL) return result;

    for (uint8_t i = 0; i < 4; i++)
    { 
      newstr=strtok(NULL,",");
      if(newstr==NULL) return result;
    } 
    newstr=strtok(NULL,"\r");
      if(newstr==NULL) return result;
    result=String(newstr);
  } 
  return result;  
}
  /**********************************************************
  Description: connect Ap
  Parameters:  ssid : wifi name
              password: wifi password     
  Return: result
               0(AT_ACK_SUCCESS)：AT Ack success
              -1(AT_ACK_ERROR)：AT Ack error
              -2(ERROR_TIME_OUT)：Serial timeout
              -3(A ERROR_SERIAL_NULL)：：Serial error                                  
  Others:     
  **********************************************************/
  int BMduino_BW16::connectToAP( String  ssid,  String password)
  {  
    int result;
    /* <AT+WMODE=1> command to Set station mode   */
    result=sendATwithACK("AT+WMODE=1,0",1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    } 
    /* <AT+CWJAP="ssid","password"> add to AP  */
    String cmd="AT+WJAP=";
    cmd+=ssid;
    cmd+=",";
    cmd+=password;
    delay(1000);

    result=sendATwithACK(cmd,5000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    } 

    return AT_ACK_SUCCESS;
  }
  /**********************************************************
  Description: Connect to TCP server
  Parameters:  ip: TCP sever IP address
              port: TCP sever port number      
  Return: result
               0(AT_ACK_SUCCESS)：AT Ack success
              -1(AT_ACK_ERROR)：AT Ack error
              -2(ERROR_TIME_OUT)：Serial timeout
              -3(A ERROR_SERIAL_NULL)：：Serial error 
  Others:        
  **********************************************************/
  int BMduino_BW16::connectTCP( String ip,  int port)
  {  
    int result;
    String  cmd = "AT+SOCKET=4,";
    cmd += ip;
    cmd += ",";
    cmd += port;  
    result=sendATwithACK(cmd,1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    } 
    return AT_ACK_SUCCESS;
  }

  /**********************************************************
  Description: Configure MQTT parameters
  Parameters:  clientlid,username,password,mqtt_host,server_port     
  Return: result
               0(AT_ACK_SUCCESS)：AT Ack success
              -1(AT_ACK_ERROR)：AT Ack error
              -2(ERROR_TIME_OUT)：Serial timeout
              -3(A ERROR_SERIAL_NULL)：：Serial error
  Others:        
  **********************************************************/
  int BMduino_BW16::mqtt_config(String clientlid,String username,String password,String mqtt_host,int server_port)
  {
    String cmd;
    int result;
  /*---------------------------------------------------------
  Description: Set mqtt mqtt_host
  command:     
  ---------------------------------------------------------*/
    cmd="AT+MQTT=1,\"";
    cmd+=mqtt_host;
    cmd+="\"";
    result=sendATwithACK(cmd,1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    } 
    delay(500);
  /*---------------------------------------------------------
  Description: Set mqtt port
  command:     
  ---------------------------------------------------------*/
    cmd="AT+MQTT=2,";
    cmd+=server_port;
    result=sendATwithACK(cmd,1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    } 
    delay(500);
  /*---------------------------------------------------------
  Description: Set connect mode
  command:     
  ---------------------------------------------------------*/
    cmd="AT+MQTT=3,1";
    result=sendATwithACK(cmd,1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    } 
    delay(500);
  /*---------------------------------------------------------
  Description: Set mqtt client ID
  command:     AT+MQTTCLIENTID=<LinkID>,<"client_id">
  ---------------------------------------------------------*/
    cmd="AT+MQTT=4,\"";
    cmd+=clientlid;
    cmd+="\"";
    result=sendATwithACK(cmd,1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    }  
    delay(500); 
  /*---------------------------------------------------------
  Description: Set mqtt username
  command:     AT+MQTTUSERNAME=<LinkID>,<"username">
  ---------------------------------------------------------*/
    cmd="AT+MQTT=5,\"";
    cmd+=username;
    cmd+="\"";
    result=sendATwithACK(cmd,1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    } 
    delay(500);
  /*---------------------------------------------------------
  Description: Set mqtt userpassword
  command:     AT+MQTTPASSWORD=<LinkID>,<"password">
  ---------------------------------------------------------*/
    cmd="AT+MQTT=6,\"";
    cmd+=password;
    cmd+="\"";
     result=sendATwithACK(cmd,1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    }     
    delay(500);        
   /*---------------------------------------------------------
  Description: Connect  MQTT Broker
  command:     AT+MQTTCONN=<LinkID>,<"host">,<port>,<reconnect>
  ---------------------------------------------------------*/
  //connect to aliyun

    result=sendATwithACK("AT+MQTT",5000,"MQTT_CONNECT");
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    } 

    return AT_ACK_SUCCESS;
  }
    /**********************************************************
  Description: set Subscribetopic
  Parameters: subscribetopic:Scribed topic       
  Return: result
               0(AT_ACK_SUCCESS)：AT Ack success
              -1(AT_ACK_ERROR)：AT Ack error
              -2(ERROR_TIME_OUT)：Serial timeout
              -3(A ERROR_SERI,AL_NULL)：：Serial error 
  Others:        
  **********************************************************/
  int BMduino_BW16::mqtt_setSubscribetopic(String subscribetopic)
  {
    int result;
    String cmd;
    cmd="AT+MQTTSUB=\"";
    cmd+=subscribetopic;
    cmd+="\",0";
    
    result=sendATwithACK(cmd,1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    }  
     return AT_ACK_SUCCESS;
  }
 /**********************************************************
  Description: Send data to IOT (data type:string)
  Parameters:  Dlength: data length
              topic : MQTT topic Data      
  Return: result
               0(AT_ACK_SUCCESS)：AT Ack success
              -1(AT_ACK_ERROR)：AT Ack error
              -2(ERROR_TIME_OUT)：Serial timeout
              -3(A ERROR_SERIAL_NULL)：：Serial error  
  Others:        
  **********************************************************/
  int BMduino_BW16::mqtt_writeString(String Dbuffer,String topic)
  {
    int result;
    String  cmd = "AT+MQTTPUB=\"";
    cmd+=topic;
    cmd+="\",0,0,\"";
    cmd+=Dbuffer;
    cmd+="\"";
    result=sendATwithACK(cmd,1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    }  
     return AT_ACK_SUCCESS;  
  }
  /**********************************************************
  Description: Send data to IOT (data type:byte)
  Parameters:  Dlength:   data length
              *Dbuffer : Storing Data
              topic:   PUBLISHTOPIC         
   Return: result
               0(AT_ACK_SUCCESS)：AT Ack success
              -1(AT_ACK_ERROR)：AT Ack error
              -2(ERROR_TIME_OUT)：Serial timeout
              -3(A ERROR_SERIAL_NULL)：：Serial error 
  Others:        
  **********************************************************/
  int BMduino_BW16::mqtt_writeBytes(char Dbuffer[],int Dlength,String topic)
  {
    int result;
    String  cmd = "AT+MQTTPUBRAW=\"";
    cmd+=topic;
    cmd+="\",0,0,";
    cmd+=Dlength;
  
    result=sendATwithACK(cmd,1000);
    if(result != AT_ACK_SUCCESS )
    {
      return result;
    }  
    
    for (uint8_t i = 0; i < Dlength; i++)
    {
      _serial->print(Dbuffer[i]); 

    }
    return AT_ACK_SUCCESS;
  }
  /**********************************************************
  Description: read data from module connect TCP server
  Parameters:  IotReciveBuff:Storing String data  
              IotReciveBufflen:tring length 
              topic:data form topic
  Return:    read result
               0(MQTT_NO_DATA_READ)：MQTT read no data 
              1(MQTT_IS_DATA_READ)：  MQTT read success
  Others:        
  **********************************************************/
 //const char testchar[]="+EVENT:MQTT_SUB,channels/2804190/subscribe/fields/field1,5,36.50";

  int BMduino_BW16::mqtt_readSubscribeData(String *IotReciveBuff,int *IotReciveBufflen,String *ReciveTopic)
  {

    resLength=0;
    *IotReciveBufflen=0;

    if(_serial->available())
    {
      delay(10);
      while(_serial->available())
      {
        BW16Response[resLength++] = _serial->read();
        if(resLength == RES_MAX_LENGTH) clearResponse();
      }
    }  

      if(resLength>0)    
      {
        char *newstr;
        if(strstr(BW16Response, "+EVENT:MQTT_SUB") != NULL)
        {
                newstr=strtok(BW16Response,",");
                if(newstr==NULL) return MQTT_NO_DATA_READ;
                newstr=strtok(NULL,",");
                *ReciveTopic=String(newstr);
                newstr=strtok(NULL,",");
                *IotReciveBufflen=atoi(newstr);
                newstr=strtok(NULL,"\r\n");
                *IotReciveBuff=String(newstr);
                return MQTT_IS_DATA_READ;
        }
            
      }
      else
        return MQTT_NO_DATA_READ;
  }


  /**********************************************************
  Description: clear  data buffer
  Parameters:  void      
  Return:  void    
  Others:        
  **********************************************************/
//AT+HTTPCLIENTLINE=1,2,,"iot.arduino.org.tw",8888,"/bigdata/dhtdata/dhDatatadd.php?MAC=AABBCCDDEEFF&T=34&H=34"
  String BMduino_BW16::http_getString(int type,String serverURL,int port,String subURL)
  {
    String result="AT error";
    int res;
    String  cmd = "AT+HTTPCLIENTLINE=";
    cmd+=type;
    cmd+=",2,,\"";
    cmd+=serverURL;
    cmd+="\",";
    cmd+=port;
    cmd+=",\"";
    cmd+=subURL;
    cmd+="\"";
    res=sendATwithACK(cmd,5000);
    if(res == AT_ACK_SUCCESS )
    {
      // Serial.print(BW16Response);  
      //BW16Response[500]='\0';
      char *newStr;
      newStr=str_getline(BW16Response,2);
      result=String(newStr);
     // result="AT OK";
      
    }  
   
    return result;
  }
  /**********************************************************
  Description: clear  data buffer
  Parameters:  void      
  Return:  void    
  Others:        
  **********************************************************/
  void BMduino_BW16::clearResponse()
  {
    memset(BW16Response,'\0',RES_MAX_LENGTH);
    resLength = 0;
  }
