/*****************************************************************
File:        ThingSpeakSubscribe.ino
Description: Connect ThingSpeak through MQTT parameters and send data to the specified channel
******************************************************************/
#include "BMduino_BW16.h"
#include "ThingSpeakSubscribe.h"

#include <BMD31M090.h>
#include <BM25S2021-1.h>

BMduino_BW16 Wifi(&Serial3);   //Please uncomment out this line of code if you use HW Serial1 on BMduino
BMD31M090     BMD31(128,64, &Wire2); //Please uncomment out this line of code if you use HW Wire on BMduino

String ReciveBuff;
int ReciveBufflen;
String DATA_BUF ;                     //
String topic ;                        //MQTT_Topic

#define RES_MAX_LENGTH 200            //max buffer length
char  OledBuff[RES_MAX_LENGTH];   //serial buffer


void Display();

void setup() 
{
  BMD31.begin(0x3C);
  BMD31.setFont(FontTable_8X16);
  delay(100);     
  Serial.begin(9600);                                
  Wifi.begin();
  Wifi.reset(); 
  Display();
//Reset module
  if(Wifi.sendATwithACK("AT+RST",1000)!=AT_ACK_SUCCESS)//rest
  {
    Serial.println("AT error!Please check the connection and power on again.");
    while(1);
  }
  else
    Serial.println("Rest...");
  delay(3000);
//Connect to WiFi
  Serial.println("Start Connect to WiFi.");
  if(Wifi.connectToAP(WIFI_SSID,WIFI_PASS)!=AT_ACK_SUCCESS) 
  {   
    Serial.println("Wifi error,please check：.");
    Serial.println("1.Wifi is opening?.");
    Serial.println("2.Confirm that Wifi SSID and password is correct.");
    while(1);
  } 
  else
  {
    Serial.println("Wifi connect ok!"); 
  } 
  delay(2000);

  //Connect to ThingSpeak
  Serial.print("ThingSpeak Connection Results：");
  if(Wifi.mqtt_config(CLIENTLID,USERNAME,PASSWORD,MQTT_HOST,SERVER_PORT)==AT_ACK_SUCCESS)
  {
    Serial.println("MQTT ThingSpeak fail");
  }
  else
  {
    Serial.println("MQTT ThingSpeak connect ok!"); 
  } 
  delay(200);

  Wifi.mqtt_setSubscribetopic(SUBSCRIBERTOPIC2);
  Wifi.mqtt_setSubscribetopic(SUBSCRIBERTOPIC1); 
}
void loop() 
{ 
      //Receive data from 
        Wifi.mqtt_readSubscribeData(&ReciveBuff,&ReciveBufflen,&topic);             
        if(ReciveBufflen)
        {
          if(topic==SUBSCRIBERTOPIC1)
          {
            ReciveBuff.toCharArray(OledBuff,7);
            BMD31.drawString(40,2,(u8*)OledBuff);
            BMD31.drawString(85,2,(u8*)"%");
            ReciveBufflen=0;
          }
          if(topic==SUBSCRIBERTOPIC2)
          {
            ReciveBuff.toCharArray(OledBuff,7);
            BMD31.drawString(40,6,(u8*)OledBuff);
            BMD31.drawString(85,6,(u8*)"C");
            ReciveBufflen=0;
          }
        }
    clearBuff();
}  
void clearBuff(){
  memset(OledBuff,'\0',RES_MAX_LENGTH);
}
void Display()
{
  BMD31.display();
  BMD31.drawString(5,0,(u8*)"Humidity:");
  BMD31.drawString(5,4,(u8*)"Temperature:");
}
