/*****************************************************************
File:        ThingSpeakPublish.ino
Description: Connect ThingSpeak through MQTT parameters and send data to the specified channel
******************************************************************/
#include "BMduino_BW16.h"
#include "ThingSpeakPublish.h"
#include <BMD31M090.h>
#include <BM25S2021-1.h>

BMduino_BW16 Wifi(&Serial3);   //Please uncomment out this line of code if you use HW Serial1 on BMduino
BM25S2021_1 BMht(&Wire2);
float data1;
String Humidity;
String Temperature;
String DATA_BUF ;    

void Display();

void setup() 
{ 
  delay(100);
  Serial.begin(115200);           
  Wifi.begin(115200); 
  BMht.begin();  
//  Wifi.testAT();
//Reset module
  if(Wifi.sendATwithACK("AT+RST",1000)!=AT_ACK_SUCCESS)//rest
  {
    Serial.println("AT error!Please check the connection and power on again.");
    while(1);
  }
  else
    Serial.println("Rest...");
  delay(3000);
//Connect to WiFi
  Serial.println("Start Connect to WiFi.");
  if(Wifi.connectToAP(WIFI_SSID,WIFI_PASS)!=AT_ACK_SUCCESS) 
  {   
    Serial.println("Wifi error,please check：.");
    Serial.println("1.Wifi is opening?.");
    Serial.println("2.Confirm that Wifi SSID and password is correct.");
    while(1);
  } 
  else
  {
    Serial.println("Wifi connect ok!"); 
  } 
  delay(2000);
  //Connect to ThingSpeak
  Serial.print("ThingSpeak Connection Results：");
  if(Wifi.mqtt_config(CLIENTLID,USERNAME,PASSWORD,MQTT_HOST,SERVER_PORT)!=AT_ACK_SUCCESS)
  {
    Serial.println("MQTT ThingSpeak fail");
  }
  else
  {
    Serial.println("MQTT ThingSpeak connect ok!"); 
  } 
  delay(200);
}
void loop() 
{ 
    data1=BMht.readHumidity();
    Humidity=String(data1,2);
    DATA_BUF = "field1="; 
    DATA_BUF += Humidity; 
    //send humidity data to ThingSpeak
    if(Wifi.mqtt_writeString(DATA_BUF,PUBLISHTOPIC))
      {
        Serial.println("Send String data success");
        delay(1000);
      }

    data1=BMht.readTemperature(false);
   
    Temperature=String(data1,2);
    DATA_BUF = "field2="; 
    DATA_BUF += Temperature; 
     //send temperature data to ThingSpeak
    if(Wifi.mqtt_writeString(DATA_BUF,PUBLISHTOPIC))
      {
        Serial.println("Send String data success");
        delay(1000);
      }
    delay(2000);
}  
