/*****************************************************************
File:        ThingSpeak.ino
Description: Connect ThingSpeak through MQTT parameters and send data to the specified channel
******************************************************************/

#include "BMduino_BW16.h"
#include "ThingSpeak.h"

BMduino_BW16 Wifi(&Serial1);  //Please uncomment out this line of code if you use HW Serial1 on BMduino
String ReciveBuff;
int ReciveBufflen;
String topic ;                        //MQTT_Topic
String DATA_BUF="field1="; 

void setup() 
{       

  delay(100);
  Serial.begin(115200);           
  Wifi.begin(115200); 
//  Wifi.testAT();
//Reset module
  if(Wifi.sendATwithACK("AT+RST",1000)!=AT_ACK_SUCCESS)//rest
  {
    Serial.println("AT error!Please check the connection and power on again.");
    while(1);
  }
  else
    Serial.println("Rest...");
  delay(3000);
//Connect to WiFi
  Serial.println("Start Connect to WiFi.");
  if(Wifi.connectToAP(WIFI_SSID,WIFI_PASS)!=AT_ACK_SUCCESS) 
  {   
    Serial.println("Wifi error,please check：.");
    Serial.println("1.Wifi is opening?.");
    Serial.println("2.Confirm that Wifi SSID and password is correct.");
    while(1);
  } 
  else
  {
    Serial.println("Wifi connect ok!"); 
  } 
  delay(2000);


//connect to aliyun
  if(Wifi.mqtt_config(CLIENTLID,USERNAME,PASSWORD,MQTT_HOST,SERVER_PORT)!=AT_ACK_SUCCESS)//rest
  {
    Serial.println("Failed to connnect Thingspeak.");
    while(1);
  }
  else
    Serial.println("Thingspeak is connnected");
}

uint8_t test_send;
void loop() 
{        
        //send data to ThingSpeak
        DATA_BUF = "field1="+String(test_send);
        
        if(Wifi.mqtt_writeString(DATA_BUF,PUBLISHTOPIC)==AT_ACK_SUCCESS)
        { 
           Serial.println(DATA_BUF); 
           Serial.println("Send data success");  
           test_send++;
           
        } 
        delay(3000); 
}
