/*****************************************************************
File:         TCP.ino
Description: 1. Hardware serial port 1 is used for communication with BMC81M001, with a communication rate of 115200bps
             2. The serial port is used as a monitoring serial port to print and output some status of BMC81M001
             3. Automatically complete BMC81M001 networking action when powered on
             4. When serial port sends data, its data is directly transmitted through to TCP server
******************************************************************/
#include "BMduino_BW16.h"
#include "TCPServer.h"

#define WIFI_SERIAL Serial1
BMduino_BW16 Wifi(&WIFI_SERIAL);//Please uncomment out this line of code if you use HW Serial1 on BMduino

void setup() 
{
  delay(100);
  Serial.begin(115200);           
  Wifi.begin(115200); 
//  Wifi.testAT();
//Reset module
  if(Wifi.sendATwithACK("AT+RST",1000)!=AT_ACK_SUCCESS)//rest
  {
    Serial.println("AT error!Please check the connection and power on again.");
    while(1);
  }
  else
    Serial.println("Rest...");
  delay(3000);
//Connect to WiFi
  Serial.println("Start Connect to WiFi.");
  if(Wifi.connectToAP(WIFI_SSID,WIFI_PASS)!=AT_ACK_SUCCESS) 
  {   
    Serial.println("Wifi error,please check：.");
    Serial.println("1.Wifi is opening?.");
    Serial.println("2.Confirm that Wifi SSID and password is correct.");
    while(1);
  } 
  else
  {
    Serial.println("Wifi connect ok!"); 
  } 
  delay(2000);
// Connect to TCP
  Serial.println("Start Connect to TCP.");
  if(Wifi.connectTCP(IP,IP_Port)!=AT_ACK_SUCCESS)
  { 
    Serial.println("TCP error.please check：");
    Serial.println("1.TCP Server is opening.");
    Serial.println("2.Confirm that IP and port is correct.");
    while(1);
  } 
  else
  {
    Serial.println("TCP connect ok!");
    
  }
  delay(1000);
  Serial.println("start  TCP transmit ");
// Enter transparent transmission
  Wifi.sendATwithACK("AT+SOCKETTT",1000);
}


void loop() {
  //APP->BMduino
    if(WIFI_SERIAL.available())//if wifi TCP received
    {
      u8 test_read;
      test_read=WIFI_SERIAL.read();
      Serial.write(test_read);//Send to serial monitor
    } 
  //BMduino->APP
    if(Serial.available())//serial monitor received
    {
      u8 test_read;
      test_read=Serial.read();
      WIFI_SERIAL.write(test_read);//send to wifi TCP
    } 
}
