/*****************************************************************
File:        ONENET.ino
Description: Connect to the onenet platform to upload and download data
******************************************************************/
#include "ONENET.h"
#define WIFI_SERIAL Serial1
BMduino_BW16 Wifi(&WIFI_SERIAL);  //Please uncomment out this line of code if you use HW Serial1 on BMduino

String Data_String="Hello";
int Data_int=30;
float Temperature=27.5;
char pub[200];

void setup()  
{ 
  delay(100);
  Serial.begin(115200);           
  Wifi.begin(115200); 
//  Wifi.testAT();
//Reset module
  if(Wifi.sendATwithACK("AT+RST",1000)!=AT_ACK_SUCCESS)//rest
  {
    Serial.println("AT error!Please check the connection and power on again.");
    while(1);
  }
  else
    Serial.println("Rest...");
  delay(3000);
//Connect to WiFi
  Serial.println("Start Connect to WiFi.");
  if(Wifi.connectToAP(WIFI_SSID,WIFI_PASS)!=AT_ACK_SUCCESS) 
  {   
    Serial.println("Wifi error,please check：.");
    Serial.println("1.Wifi is opening?.");
    Serial.println("2.Confirm that Wifi SSID and password is correct.");
    while(1);
  } 
  else
  {
    Serial.println("Wifi connect ok!"); 
  } 
  delay(2000);
  //connect to ONENET
  if(Wifi.mqtt_config(CLIENTLID,USERNAME,PASSWORD,MQTT_HOST,SERVER_PORT)!=AT_ACK_SUCCESS)//rest
  {
    Serial.println("failed to connnect ONENET.");
    while(1);
  }
  else
    Serial.println("ONENET is connnected");

  delay(200);
  Wifi.mqtt_setSubscribetopic(ONENET_TOPIC_PROP_SET);
  Wifi.mqtt_setSubscribetopic(ONENET_TOPIC_PROP_GET);
  Wifi.mqtt_setSubscribetopic(ONENET_TOPIC_PROP_GET_REPLY);
  Wifi.mqtt_setSubscribetopic(ONENET_TOPIC_PROP_SET_REPLY);
  Wifi.mqtt_setSubscribetopic(ONENET_TOPIC_PROP_POST_REPLY);
  //Single upload
    String temp=String(Temperature,1);
    SET_BUF ="{\"id\":\"";
    SET_BUF +=ID;
    ID++;
    SET_BUF +="\",";
    SET_BUF +="\"version\":\"1.0\",\"params\":";
    SET_BUF += "{\"temp\":{\"value\":"; 
    SET_BUF +=temp;
    SET_BUF +="},\"humi\":{\"value\":";
    SET_BUF +=Data_int;
    SET_BUF +="},\"String\":{\"value\":\"";
    SET_BUF +=Data_String;
    SET_BUF +="\"}}}";
    SET_BUF.toCharArray(pub,SET_BUF.length()+1);
    if(Wifi.mqtt_writeBytes(pub,SET_BUF.length(),ONENET_TOPIC_PROP_POST))
      {
        Serial.println("Send String data success");
      }
    delay(1000);
}
void loop() 
{ 
      //OneNet->BMduino
    if(WIFI_SERIAL.available())//if  BW16 received
    {
      u8 test_read;
      test_read=WIFI_SERIAL.read();
      Serial.write(test_read);//Send to serial monitor
    } 
}  
