/*****************************************************************
File:        Aliyun_Iot.ino
Description: 1. Hardware serial port 1 is used for communication with BMC81M001, with a communication rate of 115200bps
             2. The serial port is used as a monitoring serial port to print and output some status of BMC81M001
             3. Automatically complete BMC81M001 networking action when powered on
             4. When the serial port sends data, its data is directly transmitted to the ALIYUN IOT platform through transparent transmission
******************************************************************/
#include "BMduino_BW16.h"
#include "Aliyun_Iot.h"
#define WIFI_SERIAL Serial1
BMduino_BW16 Wifi(&WIFI_SERIAL);  //Please uncomment out this line of code if you use HW Serial1 on BMduino

void setup() {

  delay(100);
  Serial.begin(115200);           
  Wifi.begin(115200); 
//  Wifi.testAT();
//Reset module
  if(Wifi.sendATwithACK("AT+RST",1000)!=AT_ACK_SUCCESS)//rest
  {
    Serial.println("AT error!Please check the connection and power on again.");
    while(1);
  }
  else
    Serial.println("Rest...");
  delay(3000);
//Connect to WiFi
  Serial.println("Start Connect to WiFi.");
  if(Wifi.connectToAP(WIFI_SSID,WIFI_PASS)!=AT_ACK_SUCCESS) 
  {   
    Serial.println("Wifi error,please check：.");
    Serial.println("1.Wifi is opening?.");
    Serial.println("2.Confirm that Wifi SSID and password is correct.");
    while(1);
  } 
  else
  {
    Serial.println("Wifi connect ok!"); 
  } 
  delay(2000);

//connect to aliyun
  if(Wifi.mqtt_config(CLIENTLID,USERNAME,PASSWORD,MQTT_HOST,SERVER_PORT)!=AT_ACK_SUCCESS)//rest
  {
    Serial.println("failed to connnect aliyun.");
    while(1);
  }
  else
    Serial.println("Aliyun is connnected");
//set Subscribe topic
 if(Wifi.mqtt_setSubscribetopic(SUBSCRIBERTOPIC)!=AT_ACK_SUCCESS)
 {
    Serial.println("failed to Subscribet.");
    while(1);
  }
  else
    Serial.println("Subscribet is OK");
}

void loop() {
    //Aliyun->BMduino
    if(WIFI_SERIAL.available())//if  BW16 received
    {
      u8 test_read;
      test_read=WIFI_SERIAL.read();
      Serial.write(test_read);//Send to serial monitor
    } 
  //BMduino->Aliyun
    if(Serial.available())//serial monitor received
    {
      u8 test_read;
      //String data="\\\"params\\\"";
      test_read=Serial.read();
      //AT+MQTTPUB="/sys/a1CPfyxYrKi/name/thing/event/property/post",0,0,"{\"params\":{\"temp\":80}}"
      Wifi.mqtt_writeString("{\\\"params\\\":{\\\"temp\\\":"+String(test_read)+"}}",PUBLISHTOPIC);
    } 
}
