/* -----------------------------------------------------------------
   AY3891x Library
   https://github.com/Andy4495/AY3891x

   This file contains pre-made definitions for sounds which
   can be generated by AY-3=891x chip.

   1/1/21 - A.T. - Original
   08/24/21 - A.T. - Support PROGMEM for Notes[] array

*/

#ifndef AY3891X_SOUNDS_H
#define AY3891X_SOUNDS_H

// Musical Notes
// 1 MHz clock by default. For 2MHz, multiple by 2. For 4 MHz, multiply by 4.
// 1 MHz clock cannot produce distinct frequencies for every note in Octave 8.
// The following enums can be used to reference specific notes
// in the Notes[] array defined in AY3891x_sounds.h.
enum {
  C_0, C_0S, D_0, D_0S, E_0, F_0, F_0S, G_0, G_0S, A_0, A_0S, B_0,
  C_1, C_1S, D_1, D_1S, E_1, F_1, F_1S, G_1, G_1S, A_1, A_1S, B_1,
  C_2, C_2S, D_2, D_2S, E_2, F_2, F_2S, G_2, G_2S, A_2, A_2S, B_2,
  C_3, C_3S, D_3, D_3S, E_3, F_3, F_3S, G_3, G_3S, A_3, A_3S, B_3,
  C_4, C_4S, D_4, D_4S, E_4, F_4, F_4S, G_4, G_4S, A_4, A_4S, B_4,
  C_5, C_5S, D_5, D_5S, E_5, F_5, F_5S, G_5, G_5S, A_5, A_5S, B_5,
  C_6, C_6S, D_6, D_6S, E_6, F_6, F_6S, G_6, G_6S, A_6, A_6S, B_6,
  C_7, C_7S, D_7, D_7S, E_7, F_7, F_7S, G_7, G_7S, A_7, A_7S, B_7,
  C_8, C_8S, D_8, D_8S, E_8, F_8, F_8S, G_8, G_8S, A_8, A_8S, B_8
};

const uint16_t PROGMEM Notes[] = {
  3823, 3609, 3406, 3213, 3034, 2863, 2703, 2551, 2408, 2273, 2145, 2025,  // Octave 0
  1911, 1804, 1703, 1607, 1517, 1432, 1351, 1276, 1204, 1136, 1073, 1012,  // Octave 1
   956,  902,  851,  804,  758,  716,  676,  638,  602,  568,  536,  506,  // Octave 2
   478,  451,  426,  402,  379,  358,  338,  319,  301,  284,  268,  253,  // Octave 3
   239,  225,  213,  201,  190,  179,  169,  159,  150,  142,  134,  127,  // Octave 4
   119,  113,  106,  100,   95,   89,   84,   80,   75,   71,   67,   63,  // Octave 5
    60,   56,   53,   50,   47,   45,   42,   40,   38,   36,   34,   32,  // Octave 6
    30,   28,   27,   25,   24,   22,   21,   20,   19,   18,   17,   16,  // Octave 7
    15,   14,   13,   13,   12,   11,   11,   10,    9,    9,    8,    8   // Octave 8
};

#endif
