# Data Tome

[![Latest Release](https://img.shields.io/github/v/release/AlexandreHiroyuki/DataTome)](https://github.com/AlexandreHiroyuki/DataTome/releases)
[![PlatformIO Registry](https://badges.registry.platformio.org/packages/alexandrehiroyuki/library/DataTome.svg)](https://registry.platformio.org/libraries/alexandrehiroyuki/DataTome)
[![Latest Release Date](https://img.shields.io/github/release-date/AlexandreHiroyuki/DataTome)](https://github.com/AlexandreHiroyuki/DataTome/releases)
[![Last Commit Date](https://img.shields.io/github/last-commit/AlexandreHiroyuki/DataTome)](https://github.com/AlexandreHiroyuki/DataTome/commits/master)

[![GitHub Stars](https://img.shields.io/github/stars/AlexandreHiroyuki/DataTome?style=flat&color=yellow)](https://github.com/AlexandreHiroyuki/DataTome/stargazers)
[![Contributors](https://img.shields.io/github/contributors-anon/AlexandreHiroyuki/DataTome)](https://github.com/AlexandreHiroyuki/DataTome/graphs/contributors)
[![Top Language](https://img.shields.io/github/languages/top/AlexandreHiroyuki/DataTome)](https://github.com/AlexandreHiroyuki/DataTome)

<p align="center">
<img src="https://raw.githubusercontent.com/AlexandreHiroyuki/DataTome/main/docs/icon.png" width="128" height="128" />
</p>

## Description

Data Tome is a C++ library for data analysis and data filtering on embedded devices (IoT). Focus on the developer's experience and performance.

- Simple Moving Average (SMA). 
- Exponential Moving Average (EMA).
- Cumulative Average (CA).
- Simple Moving Median (implemented on DataTomeAnalysis).
- Variance, Standard Deviation, and more.

## Getting Started

- This library is listed in the official [Arduino Library Manager](https://www.arduino.cc/reference/en/libraries/datatome/).
- _**—Recommended Platform—**_ Use the [PlatformIO Registry](https://registry.platformio.org/libraries/alexandrehiroyuki/DataTome) to install the library!
- You can see the source code at the [GitHub Repository](https://github.com/AlexandreHiroyuki/DataTome).
- To avoid duplicating data for smaller samples of the same data, _[check the Partials feature](https://alexandrehiroyuki.github.io/DataTomeDocs/docs/category/partials)_!

## Documentation

This library calculates statistical functions using a time-series sample implemented with a circular array that improves the performance.

- Online Docs: _[Click here to see the full documentation](https://alexandrehiroyuki.github.io/DataTomeDocs/)_

- Docs GitHub Repository: _[The documentation is coded with docusaurus, and you can visit the repository](https://github.com/AlexandreHiroyuki/DataTomeDocs)_

## Contributing

[Read here how to contribute](https://github.com/AlexandreHiroyuki/DataTome/blob/master/CONTRIBUTING.md).

It describes how to report issues, code conventions, testing, and how to publish a package on the PlatformIO Registry.

## Developed by

**Alexandre Hiroyuki** – [GitHub](https://github.com/AlexandreHiroyuki) – [LinkedIn](https://www.linkedin.com/in/alexandre-hiroyuki-yamauchi/)
