#ifndef OPENLOG_MANAGER_H
#define OPENLOG_MANAGER_H

#include <Arduino.h>

class OpenLogManager {
public:
  OpenLogManager(Stream &serial);

  void sendEscape();
  bool enterCommandMode();          // Enter command mode (CTRL+Z x3)
  bool listFiles(String prefix);    // Show files matching the prefix
  int  getLastFileNumber(String prefix); // Returns the highest number found
  bool createNewFile(String prefix, int newNum); // Create file name+num.txt
  bool appendToFile(String filename); // Write data to file
  void writeOnFile(String msg);

private:
  Stream &_serial;
  bool waitForPrompt(unsigned long timeout = 1500);
  String readAll(unsigned long timeout = 1000);
};

#endif