/*
  TestOpenLog.ino - Example for OpenLogManager Library
  Created by Alby312
*/

#include <OpenLogManager.h>
// Include SoftwareSerial if using Uno/Nano, otherwise use Serial1/Serial2 on Mega/Teensy/ESP
#include <SoftwareSerial.h>

// RX pin 10, TX pin 11 (Connect to OpenLog TX and RX, Arduino TX to Openlog RX and Arduino RX to Openlog TX)
SoftwareSerial openLogSerial(10, 11);

// Initialize the manager passing the serial stream
OpenLogManager myLogger(openLogSerial);

void setup() {
  Serial.begin(9600);       // Debug on PC
  openLogSerial.begin(9600); // Communication with OpenLog
  delay(2000);

  Serial.println(F("Starting OpenLog Manager..."));

  // 1. Enter Command Mode
  if (myLogger.enterCommandMode()) {
    Serial.println(F("Entered Command Mode successfully."));

    // 2. Find the index of the last file (e.g., if log3.txt exists, returns 3)
    int lastIndex = myLogger.getLastFileNumber("log");
    int newIndex = lastIndex + 1;

    Serial.print(F("Last log index: "));
    Serial.println(lastIndex);
    Serial.print(F("Creating new file: log"));
    Serial.print(newIndex);
    Serial.println(F(".txt"));

    // 3. Create the new file
    if (myLogger.createNewFile("log", newIndex)) {
      Serial.println(F("File created."));
      
      // 4. Start appending data to the file
      if (myLogger.appendToFile("log" + String(newIndex) + ".txt")) {
        Serial.println(F("Ready to log data."));
      }
    } else {
      Serial.println(F("Error creating file."));
    }
  } else {
    Serial.println(F("Error: OpenLog not responding. Check connections."));
  }
}

void loop() {
  // Write data periodically
  String dataLine = "Time: " + String(millis()) + " ms | Value: " + String(analogRead(A0)) + "\r\n";
  
  myLogger.writeOnFile(dataLine);
  
  // Blink LED to indicate activity
  digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN));
  
  delay(100);
}