# OpenLogManager

A lightweight and simple Arduino library to manage SparkFun OpenLog (and compatible) modules via Serial.

Author: **Alby312** Email: alberto.mugavero@gmail.com

## Description
This library abstracts the command sequences required to interface with OpenLog. It allows you to easily switch to command mode, list files, find the last incremental log file, create new files, and append data.

## Features
* **Command Mode Handling:** Handles the `CTRL+Z` sequence automatically.
* **Incremental Logging:** Helper function `getLastFileNumber` to easily manage `log1.txt`, `log2.txt`, etc.
* **File Creation:** Simple method to instantiate new text files.
* **Stream Support:** Works with `HardwareSerial` (Serial1, Serial2) and `SoftwareSerial`.

## Installation
1.  Download this repository as a ZIP file.
2.  Open the Arduino IDE.
3.  Go to **Sketch** -> **Include Library** -> **Add .ZIP Library...**
4.  Select the downloaded file.

## Know problems
1. When a file is closed, the last character of the file is CTRL+Z x3.

## Usage Example

```cpp
#include <OpenLogManager.h>
#include <SoftwareSerial.h>

// RX, TX connected to OpenLog
SoftwareSerial openLogSerial(10, 11);

OpenLogManager myLogger(openLogSerial);

void setup() {
  Serial.begin(9600);
  openLogSerial.begin(9600);

  Serial.println("Initializing OpenLog...");

  // Enter command mode
  if (myLogger.enterCommandMode()) {
    Serial.println("Command Mode: OK");
    
    // Find last log number and create a new one
    int lastLog = myLogger.getLastFileNumber("log");
    int newLog = lastLog + 1;
    
    if (myLogger.createNewFile("log", newLog)) {
      Serial.print("Created file: log");
      Serial.print(newLog);
      Serial.println(".txt");
      
      // Switch to append mode
      myLogger.appendToFile("log" + String(newLog) + ".txt");
    }
  } else {
    Serial.println("Error: Could not connect to OpenLog");
  }
}

void loop() {
  myLogger.writeOnFile("Sensor Data: " + String(millis()) + "\r\n");
  delay(1000);
}